/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.web.session.HttpSessionFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.session.SessionMetaData;
import org.wildfly.clustering.web.undertow.session.UndertowSpecificationProvider;

public class UndertowHttpSessionFactoryTestCase {
    private final HttpSessionFactory<HttpSession, ServletContext> factory = UndertowSpecificationProvider.INSTANCE;

    @Test
    public void getId() {
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        String expected = "session";
        Mockito.when((Object)session.getId()).thenReturn((Object)expected);
        String result = ((HttpSession)this.factory.createHttpSession(session, (Object)context)).getId();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void getCreationTime() {
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Instant now = Instant.now();
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getCreationTime()).thenReturn((Object)now);
        long result = ((HttpSession)this.factory.createHttpSession(session, (Object)context)).getCreationTime();
        Assert.assertEquals((long)now.toEpochMilli(), (long)result);
    }

    @Test
    public void getLastAccessedTime() {
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Instant now = Instant.now();
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getLastAccessStartTime()).thenReturn((Object)now);
        long result = ((HttpSession)this.factory.createHttpSession(session, (Object)context)).getLastAccessedTime();
        Assert.assertEquals((long)now.toEpochMilli(), (long)result);
    }

    @Test
    public void getMaxInactiveInterval() {
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Duration interval = Duration.of(100L, ChronoUnit.SECONDS);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getMaxInactiveInterval()).thenReturn((Object)interval);
        int result = ((HttpSession)this.factory.createHttpSession(session, (Object)context)).getMaxInactiveInterval();
        Assert.assertEquals((long)interval.getSeconds(), (long)result);
    }

    @Test
    public void setMaxInactiveInterval() {
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        ((HttpSession)this.factory.createHttpSession(session, (Object)context)).setMaxInactiveInterval(10);
        Mockito.verifyNoInteractions((Object[])new Object[]{session});
    }

    @Test
    public void getServletContext() {
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        ServletContext result = ((HttpSession)this.factory.createHttpSession(session, (Object)context)).getServletContext();
        Assert.assertSame((Object)context, (Object)result);
    }

    @Test
    public void getAttributeNames() {
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        TreeSet expected = new TreeSet();
        Mockito.when((Object)session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.getAttributeNames()).thenReturn(expected);
        Enumeration result = ((HttpSession)this.factory.createHttpSession(session, (Object)context)).getAttributeNames();
        Assert.assertEquals(new ArrayList(expected), Collections.list(result));
    }

    @Test
    public void getAttribute() {
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        String name = "name";
        Object expected = new Object();
        Mockito.when((Object)session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.getAttribute(name)).thenReturn(expected);
        Object result = ((HttpSession)this.factory.createHttpSession(session, (Object)context)).getAttribute(name);
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void setAttribute() {
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        ((HttpSession)this.factory.createHttpSession(session, (Object)context)).setAttribute("name", (Object)"value");
        Mockito.verifyNoInteractions((Object[])new Object[]{session});
    }

    @Test
    public void removeAttribute() {
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        ((HttpSession)this.factory.createHttpSession(session, (Object)context)).removeAttribute("name");
        Mockito.verifyNoInteractions((Object[])new Object[]{session});
    }

    @Test
    public void invalidate() {
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        ((HttpSession)this.factory.createHttpSession(session, (Object)context)).invalidate();
        Mockito.verifyNoInteractions((Object[])new Object[]{session});
    }

    @Test
    public void isNew() {
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.isNew()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Assert.assertTrue((boolean)((HttpSession)this.factory.createHttpSession(session, (Object)context)).isNew());
        Assert.assertFalse((boolean)((HttpSession)this.factory.createHttpSession(session, (Object)context)).isNew());
    }
}

