/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.time.Duration;
import java.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.undertow.session.DistributableInactiveSessionStatistics;
import org.wildfly.clustering.web.undertow.session.RecordableInactiveSessionStatistics;

public class DistributableInactiveSessionStatisticsTestCase {
    private final RecordableInactiveSessionStatistics statistics = new DistributableInactiveSessionStatistics();

    @Test
    public void test() {
        ImmutableSessionMetaData metaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        Instant now = Instant.now();
        Instant created = now.minus(Duration.ofMinutes(20L));
        Mockito.when((Object)metaData.isExpired()).thenReturn((Object)false);
        Mockito.when((Object)metaData.getCreationTime()).thenReturn((Object)created);
        this.statistics.record((Object)metaData);
        Assert.assertEquals((long)0L, (long)this.statistics.getExpiredSessionCount());
        Assert.assertEquals((long)20L, (long)this.statistics.getMaxSessionLifetime().toMinutes());
        Assert.assertEquals((long)20L, (long)this.statistics.getMeanSessionLifetime().toMinutes());
        now = Instant.now();
        created = now.minus(Duration.ofMinutes(10L));
        Mockito.when((Object)metaData.isExpired()).thenReturn((Object)true);
        Mockito.when((Object)metaData.getCreationTime()).thenReturn((Object)created);
        this.statistics.record((Object)metaData);
        Assert.assertEquals((long)1L, (long)this.statistics.getExpiredSessionCount());
        Assert.assertEquals((long)20L, (long)this.statistics.getMaxSessionLifetime().toMinutes());
        Assert.assertEquals((long)15L, (long)this.statistics.getMeanSessionLifetime().toMinutes());
        this.statistics.reset();
        Assert.assertEquals((long)0L, (long)this.statistics.getExpiredSessionCount());
        Assert.assertEquals((long)0L, (long)this.statistics.getMaxSessionLifetime().toMinutes());
        Assert.assertEquals((long)0L, (long)this.statistics.getMeanSessionLifetime().toMinutes());
    }
}

