/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.routing;

import java.util.AbstractMap;
import org.jboss.as.web.session.RoutingSupport;
import org.jboss.as.web.session.SessionIdentifierCodec;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.web.routing.RouteLocator;
import org.wildfly.clustering.web.undertow.routing.DistributableSessionIdentifierCodec;

public class DistributableSessionIdentifierCodecTestCase {
    private final RoutingSupport routing = (RoutingSupport)Mockito.mock(RoutingSupport.class);
    private final RouteLocator locator = (RouteLocator)Mockito.mock(RouteLocator.class);
    private SessionIdentifierCodec codec = new DistributableSessionIdentifierCodec(this.locator, this.routing);

    @Test
    public void encode() {
        String sessionId = "session";
        Mockito.when((Object)this.locator.locate(sessionId)).thenReturn(null);
        CharSequence result = this.codec.encode((CharSequence)sessionId);
        Assert.assertSame((Object)sessionId, (Object)result);
        String route = "route";
        String encodedSessionId = "session.route";
        Mockito.when((Object)this.locator.locate(sessionId)).thenReturn((Object)route);
        Mockito.when((Object)this.routing.format((CharSequence)sessionId, (CharSequence)route)).thenReturn((Object)encodedSessionId);
        result = this.codec.encode((CharSequence)sessionId);
        Assert.assertSame((Object)encodedSessionId, (Object)result);
    }

    @Test
    public void decode() {
        String encodedSessionId = "session.route";
        String sessionId = "session";
        String route = "route";
        Mockito.when((Object)this.routing.parse((CharSequence)encodedSessionId)).thenReturn(new AbstractMap.SimpleImmutableEntry<String, String>(sessionId, route));
        CharSequence result = this.codec.decode((CharSequence)encodedSessionId);
        Assert.assertSame((Object)sessionId, (Object)result);
    }
}

