/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.spec.ServletContextImpl;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.web.undertow.session.Recordable;
import org.wildfly.clustering.web.undertow.session.UndertowSessionExpirationListener;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class UndertowSessionExpirationListenerTestCase {
    @Test
    public void sessionExpired() {
        Deployment deployment = (Deployment)Mockito.mock(Deployment.class);
        UndertowSessionManager manager = (UndertowSessionManager)Mockito.mock(UndertowSessionManager.class);
        SessionManager delegateManager = (SessionManager)Mockito.mock(SessionManager.class);
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        ServletContextImpl context = (ServletContextImpl)Mockito.mock(ServletContextImpl.class);
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        Map attributes = (Map)Mockito.mock(Map.class);
        ImmutableSessionMetaData metaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        ArgumentCaptor capturedSession = ArgumentCaptor.forClass(Session.class);
        Recordable recorder = (Recordable)Mockito.mock(Recordable.class);
        String expectedSessionId = "session";
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        UndertowSessionExpirationListener expirationListener = new UndertowSessionExpirationListener(deployment, listeners, recorder);
        ((Deployment)Mockito.doReturn((Object)context).when((Object)deployment)).getServletContext();
        ((ServletContextImpl)Mockito.doReturn((Object)Thread.currentThread().getContextClassLoader()).when((Object)context)).getClassLoader();
        ((Deployment)Mockito.doReturn((Object)manager).when((Object)deployment)).getSessionManager();
        ((UndertowSessionManager)Mockito.doReturn((Object)delegateManager).when((Object)manager)).getSessionManager();
        ((ImmutableSession)Mockito.doReturn((Object)expectedSessionId).when((Object)session)).getId();
        ((ImmutableSession)Mockito.doReturn((Object)attributes).when((Object)session)).getAttributes();
        ((Map)Mockito.doReturn(Set.of()).when((Object)attributes)).entrySet();
        ((ImmutableSession)Mockito.doReturn((Object)metaData).when((Object)session)).getMetaData();
        ((ImmutableSessionMetaData)Mockito.doReturn((Object)Instant.now()).when((Object)metaData)).getCreationTime();
        ((ImmutableSessionMetaData)Mockito.doReturn((Object)Instant.now()).when((Object)metaData)).getLastAccessStartTime();
        ((ImmutableSessionMetaData)Mockito.doReturn((Object)Duration.ZERO).when((Object)metaData)).getTimeout();
        expirationListener.accept(session);
        ((Recordable)Mockito.verify((Object)recorder)).record((Object)metaData);
        ((SessionListener)Mockito.verify((Object)listener)).sessionDestroyed((Session)capturedSession.capture(), (HttpServerExchange)ArgumentMatchers.isNull(), (SessionListener.SessionDestroyedReason)ArgumentMatchers.same((Object)SessionListener.SessionDestroyedReason.TIMEOUT));
        Assert.assertSame((Object)expectedSessionId, (Object)((Session)capturedSession.getValue()).getId());
        Assert.assertSame((Object)manager, (Object)((Session)capturedSession.getValue()).getSessionManager());
    }
}

