/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler;
import io.undertow.util.Protocols;
import jakarta.servlet.http.HttpSessionActivationListener;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.BatchContext;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.web.undertow.session.DistributableSession;
import org.wildfly.clustering.web.undertow.session.Recordable;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.channels.Configurable;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public class DistributableSessionTestCase {
    private final SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
    private final UndertowSessionManager manager = (UndertowSessionManager)Mockito.mock(UndertowSessionManager.class);
    private final SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
    private final org.wildfly.clustering.session.Session<Map<String, Object>> session = (org.wildfly.clustering.session.Session)Mockito.mock(org.wildfly.clustering.session.Session.class);
    private final SuspendedBatch suspendedBatch = (SuspendedBatch)Mockito.mock(SuspendedBatch.class);
    private final Consumer<HttpServerExchange> closeTask = (Consumer)Mockito.mock(Consumer.class);
    private final RecordableSessionManagerStatistics statistics = (RecordableSessionManagerStatistics)Mockito.mock(RecordableSessionManagerStatistics.class);

    @After
    public void destroy() {
        Mockito.reset((Object[])new Object[]{this.metaData, this.manager, this.config, this.session, this.suspendedBatch, this.closeTask, this.statistics});
    }

    @Test
    public void getId() {
        String id = "id";
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)id).when(this.session)).getId();
        String result = session.getId();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        Assert.assertSame((Object)id, (Object)result);
    }

    @Test
    public void newSessionRequestDone() {
        Instant creationTime = Instant.now();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)true).when((Object)this.metaData)).isNew();
        ((SessionMetaData)Mockito.doReturn((Object)creationTime).when((Object)this.metaData)).getCreationTime();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        HttpServerExchange exchange = new HttpServerExchange(null);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        ArgumentCaptor capturedLastAccessStartTime = ArgumentCaptor.forClass(Instant.class);
        ArgumentCaptor capturedLastAccessEndTime = ArgumentCaptor.forClass(Instant.class);
        ((SuspendedBatch)Mockito.doReturn((Object)batch).when((Object)this.suspendedBatch)).resume();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)true).when(this.session)).isValid();
        ((SessionMetaData)Mockito.doNothing().when((Object)this.metaData)).setLastAccess((Instant)capturedLastAccessStartTime.capture(), (Instant)capturedLastAccessEndTime.capture());
        session.requestDone(exchange);
        Instant lastAccessStartTime = (Instant)capturedLastAccessStartTime.getValue();
        Instant lastAccessEndTime = (Instant)capturedLastAccessEndTime.getValue();
        Assert.assertSame((Object)creationTime, (Object)lastAccessStartTime);
        Assert.assertNotSame((Object)creationTime, (Object)lastAccessEndTime);
        Assert.assertFalse((boolean)lastAccessStartTime.isAfter(lastAccessEndTime));
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).close();
        ((Batch)Mockito.verify((Object)batch)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(exchange);
    }

    @Test
    public void existingSessionRequestDone() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        HttpServerExchange exchange = new HttpServerExchange(null);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        ArgumentCaptor capturedLastAccessStartTime = ArgumentCaptor.forClass(Instant.class);
        ArgumentCaptor capturedLastAccessEndTime = ArgumentCaptor.forClass(Instant.class);
        ((SuspendedBatch)Mockito.doReturn((Object)batch).when((Object)this.suspendedBatch)).resume();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)true).when(this.session)).isValid();
        ((SessionMetaData)Mockito.doNothing().when((Object)this.metaData)).setLastAccess((Instant)capturedLastAccessStartTime.capture(), (Instant)capturedLastAccessEndTime.capture());
        session.requestDone(exchange);
        Instant lastAccessStartTime = (Instant)capturedLastAccessStartTime.getValue();
        Instant lastAccessEndTime = (Instant)capturedLastAccessEndTime.getValue();
        Assert.assertNotSame((Object)lastAccessStartTime, (Object)lastAccessEndTime);
        Assert.assertFalse((boolean)lastAccessStartTime.isAfter(lastAccessEndTime));
        ((SessionMetaData)Mockito.verify((Object)this.metaData)).setLastAccess((Instant)ArgumentMatchers.any(Instant.class), (Instant)ArgumentMatchers.any(Instant.class));
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).close();
        ((Batch)Mockito.verify((Object)batch)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(exchange);
    }

    @Test
    public void invalidSessionRequestDone() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        ((SessionMetaData)Mockito.verify((Object)this.metaData)).isNew();
        HttpServerExchange exchange = new HttpServerExchange(null);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        ((SuspendedBatch)Mockito.doReturn((Object)batch).when((Object)this.suspendedBatch)).resume();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)false).when(this.session)).isValid();
        session.requestDone(exchange);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.metaData});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).close();
        ((Batch)Mockito.verify((Object)batch)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(exchange);
    }

    @Test
    public void getCreationTime() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        Instant now = Instant.now();
        ((SessionMetaData)Mockito.doReturn((Object)now).when((Object)this.metaData)).getCreationTime();
        long result = session.getCreationTime();
        Assert.assertEquals((long)now.toEpochMilli(), (long)result);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        ((org.wildfly.clustering.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getMetaData();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$getCreationTime$0((Session)session));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void getLastAccessedTime() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        Instant now = Instant.now();
        ((SessionMetaData)Mockito.doReturn((Object)now).when((Object)this.metaData)).getLastAccessStartTime();
        long result = session.getLastAccessedTime();
        Assert.assertEquals((long)now.toEpochMilli(), (long)result);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        ((org.wildfly.clustering.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getMetaData();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$getLastAccessedTime$1((Session)session));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void getMaxInactiveInterval() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        long expected = 3600L;
        ((SessionMetaData)Mockito.doReturn((Object)Duration.ofSeconds(expected)).when((Object)this.metaData)).getTimeout();
        long result = session.getMaxInactiveInterval();
        Assert.assertEquals((long)expected, (long)result);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        ((org.wildfly.clustering.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getMetaData();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$getMaxInactiveInterval$2((Session)session));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void setMaxInactiveInterval() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        int interval = 3600;
        session.setMaxInactiveInterval(interval);
        ((SessionMetaData)Mockito.verify((Object)this.metaData)).setTimeout(Duration.ofSeconds(interval));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        ((org.wildfly.clustering.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getMetaData();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$setMaxInactiveInterval$3((Session)session, interval));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void getAttributeNames() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        Map attributes = (Map)Mockito.mock(Map.class);
        Set<String> expected = Collections.singleton("name");
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)attributes).when(this.session)).getAttributes();
        ((Map)Mockito.doReturn(expected).when((Object)attributes)).keySet();
        Set result = session.getAttributeNames();
        Assert.assertSame(expected, (Object)result);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        ((org.wildfly.clustering.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getAttributes();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$getAttributeNames$4((Session)session));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void getAttribute() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        String name = "name";
        Map attributes = (Map)Mockito.mock(Map.class);
        Object expected = new Object();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)attributes).when(this.session)).getAttributes();
        ((Map)Mockito.doReturn((Object)expected).when((Object)attributes)).get(name);
        Object result = session.getAttribute(name);
        Assert.assertSame((Object)expected, (Object)result);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        ((org.wildfly.clustering.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getAttributes();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$getAttribute$5((Session)session, name));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void getAuthenticatedSessionAttribute() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        String name = CachedAuthenticatedSessionHandler.class.getName() + ".AuthenticatedSession";
        Map attributes = (Map)Mockito.mock(Map.class);
        Account account = (Account)Mockito.mock(Account.class);
        AuthenticatedSessionManager.AuthenticatedSession auth = new AuthenticatedSessionManager.AuthenticatedSession(account, "FORM");
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)attributes).when(this.session)).getAttributes();
        ((Map)Mockito.doReturn((Object)auth).when((Object)attributes)).get(name);
        AuthenticatedSessionManager.AuthenticatedSession result = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttribute(name);
        Assert.assertSame((Object)account, (Object)result.getAccount());
        Assert.assertSame((Object)"FORM", (Object)result.getMechanism());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        AuthenticatedSessionManager.AuthenticatedSession expected = new AuthenticatedSessionManager.AuthenticatedSession(account, "BASIC");
        Map<CallSite, AuthenticatedSessionManager.AuthenticatedSession> localContext = Collections.singletonMap(name, expected);
        ((Map)Mockito.doReturn(null).when((Object)attributes)).get(name);
        ((org.wildfly.clustering.session.Session)Mockito.doReturn(localContext).when(this.session)).getContext();
        result = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttribute(name);
        Assert.assertSame((Object)expected, (Object)result);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        ((org.wildfly.clustering.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getAttributes();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$getAuthenticatedSessionAttribute$6((Session)session, name));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void getWebSocketChannelsSessionAttribute() {
        this.getLocalContextSessionAttribute("io.undertow.websocket.current-connections");
    }

    private void getLocalContextSessionAttribute(String name) {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        Map attributes = (Map)Mockito.mock(Map.class);
        Object expected = new Object();
        Map<String, Object> localContext = Collections.singletonMap(name, expected);
        ((org.wildfly.clustering.session.Session)Mockito.doReturn(localContext).when(this.session)).getContext();
        Object result = session.getAttribute(name);
        Assert.assertSame((Object)expected, (Object)result);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((Map)Mockito.verify((Object)attributes, (VerificationMode)Mockito.never())).get(name);
    }

    @Test
    public void setAttribute() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        String name = "name";
        Integer value = 1;
        Map attributes = (Map)Mockito.mock(Map.class);
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        Object expected = new Object();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)attributes).when(this.session)).getAttributes();
        ((Map)Mockito.doReturn((Object)expected).when((Object)attributes)).put(name, value);
        ((UndertowSessionManager)Mockito.doReturn((Object)listeners).when((Object)this.manager)).getSessionListeners();
        Object result = session.setAttribute(name, (Object)value);
        Assert.assertSame((Object)expected, (Object)result);
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeAdded((Session)session, name, (Object)value);
        ((SessionListener)Mockito.verify((Object)listener)).attributeUpdated((Session)session, name, (Object)value, expected);
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeRemoved((Session)ArgumentMatchers.same((Object)session), (String)ArgumentMatchers.same((Object)name), ArgumentMatchers.any());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        ((org.wildfly.clustering.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getAttributes();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$setAttribute$7((Session)session, name, value));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void setNewAttribute() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        String name = "name";
        Integer value = 1;
        Map attributes = (Map)Mockito.mock(Map.class);
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        Object expected = null;
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)attributes).when(this.session)).getAttributes();
        ((Map)Mockito.doReturn(expected).when((Object)attributes)).put(name, value);
        ((UndertowSessionManager)Mockito.doReturn((Object)listeners).when((Object)this.manager)).getSessionListeners();
        Object result = session.setAttribute(name, (Object)value);
        Assert.assertSame(expected, (Object)result);
        ((SessionListener)Mockito.verify((Object)listener)).attributeAdded((Session)session, name, (Object)value);
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeUpdated((Session)ArgumentMatchers.same((Object)session), (String)ArgumentMatchers.same((Object)name), ArgumentMatchers.same((Object)value), ArgumentMatchers.any());
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeRemoved((Session)ArgumentMatchers.same((Object)session), (String)ArgumentMatchers.same((Object)name), ArgumentMatchers.any());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
    }

    @Test
    public void setNullAttribute() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        String name = "name";
        Object value = null;
        Map attributes = (Map)Mockito.mock(Map.class);
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        Object expected = new Object();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)attributes).when(this.session)).getAttributes();
        ((Map)Mockito.doReturn((Object)expected).when((Object)attributes)).remove(name);
        ((UndertowSessionManager)Mockito.doReturn((Object)listeners).when((Object)this.manager)).getSessionListeners();
        Object result = session.setAttribute(name, value);
        Assert.assertSame((Object)expected, (Object)result);
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeAdded((Session)session, name, value);
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeUpdated((Session)ArgumentMatchers.same((Object)session), (String)ArgumentMatchers.same((Object)name), ArgumentMatchers.same(value), ArgumentMatchers.any());
        ((SessionListener)Mockito.verify((Object)listener)).attributeRemoved((Session)session, name, expected);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
    }

    @Test
    public void setSameAttribute() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        String name = "name";
        Integer value = 1;
        Map attributes = (Map)Mockito.mock(Map.class);
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        Integer expected = value;
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)attributes).when(this.session)).getAttributes();
        ((Map)Mockito.doReturn((Object)expected).when((Object)attributes)).put(name, value);
        ((UndertowSessionManager)Mockito.doReturn((Object)listeners).when((Object)this.manager)).getSessionListeners();
        Object result = session.setAttribute(name, (Object)value);
        Assert.assertSame((Object)expected, (Object)result);
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeAdded((Session)session, name, (Object)value);
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeUpdated((Session)ArgumentMatchers.same((Object)session), (String)ArgumentMatchers.same((Object)name), ArgumentMatchers.same((Object)value), ArgumentMatchers.any());
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeRemoved((Session)ArgumentMatchers.same((Object)session), (String)ArgumentMatchers.same((Object)name), ArgumentMatchers.any());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
    }

    @Test
    public void setAuthenticatedSessionAttribute() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        String name = CachedAuthenticatedSessionHandler.class.getName() + ".AuthenticatedSession";
        Account account = (Account)Mockito.mock(Account.class);
        AuthenticatedSessionManager.AuthenticatedSession auth = new AuthenticatedSessionManager.AuthenticatedSession(account, "FORM");
        Map attributes = (Map)Mockito.mock(Map.class);
        Account oldAccount = (Account)Mockito.mock(Account.class);
        AuthenticatedSessionManager.AuthenticatedSession oldAuth = new AuthenticatedSessionManager.AuthenticatedSession(oldAccount, "FORM");
        ArgumentCaptor capturedAuth = ArgumentCaptor.forClass(AuthenticatedSessionManager.AuthenticatedSession.class);
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)attributes).when(this.session)).getAttributes();
        ((Map)Mockito.doReturn((Object)oldAuth).when((Object)attributes)).put((String)ArgumentMatchers.same((Object)name), capturedAuth.capture());
        AuthenticatedSessionManager.AuthenticatedSession result = (AuthenticatedSessionManager.AuthenticatedSession)session.setAttribute(name, (Object)auth);
        Assert.assertSame((Object)auth.getAccount(), (Object)((AuthenticatedSessionManager.AuthenticatedSession)capturedAuth.getValue()).getAccount());
        Assert.assertSame((Object)auth.getMechanism(), (Object)((AuthenticatedSessionManager.AuthenticatedSession)capturedAuth.getValue()).getMechanism());
        Assert.assertSame((Object)oldAccount, (Object)result.getAccount());
        Assert.assertSame((Object)"FORM", (Object)result.getMechanism());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        Mockito.reset((Object[])new Map[]{attributes});
        capturedAuth = ArgumentCaptor.forClass(AuthenticatedSessionManager.AuthenticatedSession.class);
        ((Map)Mockito.doReturn(null).when((Object)attributes)).put((String)ArgumentMatchers.same((Object)name), capturedAuth.capture());
        result = (AuthenticatedSessionManager.AuthenticatedSession)session.setAttribute(name, (Object)auth);
        Assert.assertSame((Object)auth.getAccount(), (Object)((AuthenticatedSessionManager.AuthenticatedSession)capturedAuth.getValue()).getAccount());
        Assert.assertSame((Object)auth.getMechanism(), (Object)((AuthenticatedSessionManager.AuthenticatedSession)capturedAuth.getValue()).getMechanism());
        Assert.assertNull((Object)result);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        Mockito.reset((Object[])new Map[]{attributes});
        auth = new AuthenticatedSessionManager.AuthenticatedSession(account, "BASIC");
        AuthenticatedSessionManager.AuthenticatedSession oldSession = new AuthenticatedSessionManager.AuthenticatedSession(oldAccount, "BASIC");
        HashMap<CallSite, AuthenticatedSessionManager.AuthenticatedSession> localContext = new HashMap<CallSite, AuthenticatedSessionManager.AuthenticatedSession>();
        localContext.put((CallSite)((Object)name), oldSession);
        ((org.wildfly.clustering.session.Session)Mockito.doReturn(localContext).when(this.session)).getContext();
        result = (AuthenticatedSessionManager.AuthenticatedSession)session.setAttribute(name, (Object)auth);
        Assert.assertSame((Object)auth, localContext.get(name));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        ((org.wildfly.clustering.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getAttributes();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$setAuthenticatedSessionAttribute$8((Session)session, name, oldAuth));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void setWebSocketChannelsSessionAttribute() {
        this.setLocalContextSessionAttribute("io.undertow.websocket.current-connections");
    }

    private void setLocalContextSessionAttribute(String name) {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        Object newValue = new Object();
        Object oldValue = new Object();
        Map attributes = (Map)Mockito.mock(Map.class);
        HashMap<String, Object> localContext = new HashMap<String, Object>();
        localContext.put(name, oldValue);
        ((org.wildfly.clustering.session.Session)Mockito.doReturn(localContext).when(this.session)).getContext();
        Object result = session.setAttribute(name, newValue);
        Assert.assertSame((Object)oldValue, (Object)result);
        Assert.assertSame((Object)newValue, localContext.get(name));
        ((Map)Mockito.verify((Object)attributes, (VerificationMode)Mockito.never())).put(name, newValue);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
    }

    @Test
    public void removeAttribute() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        String name = "name";
        Map attributes = (Map)Mockito.mock(Map.class);
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        Object expected = new Object();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)attributes).when(this.session)).getAttributes();
        ((Map)Mockito.doReturn((Object)expected).when((Object)attributes)).remove(name);
        ((UndertowSessionManager)Mockito.doReturn((Object)listeners).when((Object)this.manager)).getSessionListeners();
        Object result = session.removeAttribute(name);
        Assert.assertSame((Object)expected, (Object)result);
        ((SessionListener)Mockito.verify((Object)listener)).attributeRemoved((Session)session, name, expected);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        ((org.wildfly.clustering.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getAttributes();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$removeAttribute$9((Session)session, name));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void removeNonExistingAttribute() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        String name = "name";
        Map attributes = (Map)Mockito.mock(Map.class);
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)attributes).when(this.session)).getAttributes();
        ((Map)Mockito.doReturn(null).when((Object)attributes)).remove(name);
        ((UndertowSessionManager)Mockito.doReturn((Object)listeners).when((Object)this.manager)).getSessionListeners();
        Object result = session.removeAttribute(name);
        Assert.assertNull((Object)result);
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeRemoved((Session)ArgumentMatchers.same((Object)session), (String)ArgumentMatchers.same((Object)name), ArgumentMatchers.any());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
    }

    @Test
    public void removeAuthenticatedSessionAttribute() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        String name = CachedAuthenticatedSessionHandler.class.getName() + ".AuthenticatedSession";
        Map attributes = (Map)Mockito.mock(Map.class);
        Account oldAccount = (Account)Mockito.mock(Account.class);
        AuthenticatedSessionManager.AuthenticatedSession oldAuth = new AuthenticatedSessionManager.AuthenticatedSession(oldAccount, "FORM");
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)attributes).when(this.session)).getAttributes();
        ((Map)Mockito.doReturn((Object)oldAuth).when((Object)attributes)).remove(ArgumentMatchers.same((Object)name));
        AuthenticatedSessionManager.AuthenticatedSession result = (AuthenticatedSessionManager.AuthenticatedSession)session.removeAttribute(name);
        Assert.assertSame((Object)oldAccount, (Object)result.getAccount());
        Assert.assertSame((Object)"FORM", (Object)result.getMechanism());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        Mockito.reset((Object[])new Map[]{attributes});
        HashMap<CallSite, AuthenticatedSessionManager.AuthenticatedSession> localContext = new HashMap<CallSite, AuthenticatedSessionManager.AuthenticatedSession>();
        AuthenticatedSessionManager.AuthenticatedSession oldSession = new AuthenticatedSessionManager.AuthenticatedSession(oldAccount, "BASIC");
        localContext.put((CallSite)((Object)name), oldSession);
        ((Map)Mockito.doReturn(null).when((Object)attributes)).remove(ArgumentMatchers.same((Object)name));
        ((org.wildfly.clustering.session.Session)Mockito.doReturn(localContext).when(this.session)).getContext();
        result = (AuthenticatedSessionManager.AuthenticatedSession)session.removeAttribute(name);
        Assert.assertSame((Object)result, (Object)oldSession);
        Assert.assertNull(localContext.get(name));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        Mockito.reset((Object[])new Map[]{attributes});
        result = (AuthenticatedSessionManager.AuthenticatedSession)session.removeAttribute(name);
        Assert.assertNull((Object)result);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        ((org.wildfly.clustering.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getAttributes();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$removeAuthenticatedSessionAttribute$10((Session)session, name));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void removeWebSocketChannelsSessionAttribute() {
        this.removeLocalContextSessionAttribute("io.undertow.websocket.current-connections");
    }

    private void removeLocalContextSessionAttribute(String name) {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        Object oldValue = new Object();
        Map attributes = (Map)Mockito.mock(Map.class);
        HashMap<String, Object> localContext = new HashMap<String, Object>();
        localContext.put(name, oldValue);
        ((org.wildfly.clustering.session.Session)Mockito.doReturn(localContext).when(this.session)).getContext();
        Object result = session.removeAttribute(name);
        Assert.assertSame((Object)oldValue, (Object)result);
        Assert.assertNull(localContext.get(name));
        ((Map)Mockito.verify((Object)attributes, (VerificationMode)Mockito.never())).remove(name);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.suspendedBatch});
    }

    @Test
    public void invalidate() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        HttpServerExchange exchange = new HttpServerExchange(null);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        Map attributes = (Map)Mockito.mock(Map.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        String sessionId = "session";
        String attributeName = "attribute";
        Object attributeValue = Mockito.mock(HttpSessionActivationListener.class);
        Recordable recorder = (Recordable)Mockito.mock(Recordable.class);
        ((UndertowSessionManager)Mockito.doReturn((Object)listeners).when((Object)this.manager)).getSessionListeners();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)true).when(this.session)).isValid();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)sessionId).when(this.session)).getId();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)attributes).when(this.session)).getAttributes();
        ((Map)Mockito.doReturn(Set.of(Map.entry("attribute", attributeValue))).when((Object)attributes)).entrySet();
        ((RecordableSessionManagerStatistics)Mockito.doReturn((Object)recorder).when((Object)this.statistics)).getInactiveSessionRecorder();
        ((SuspendedBatch)Mockito.doReturn((Object)batch).when((Object)this.suspendedBatch)).resume();
        session.invalidate(exchange);
        ((Recordable)Mockito.verify((Object)recorder)).record((Object)this.metaData);
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).invalidate();
        ((SessionConfig)Mockito.verify((Object)this.config)).clearSession(exchange, sessionId);
        ((SessionListener)Mockito.verify((Object)listener)).sessionDestroyed((Session)session, exchange, SessionListener.SessionDestroyedReason.INVALIDATED);
        ((SessionListener)Mockito.verify((Object)listener)).attributeRemoved((Session)session, attributeName, attributeValue);
        ((Batch)Mockito.verify((Object)batch)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(exchange);
    }

    @Test
    public void invalidateInvalid() {
        String sessionId = "session";
        HttpServerExchange exchange = new HttpServerExchange(null);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)sessionId).when(this.session)).getId();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        ((SuspendedBatch)Mockito.doReturn((Object)batch).when((Object)this.suspendedBatch)).resume();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)false).when(this.session)).isValid();
        ((org.wildfly.clustering.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).invalidate();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$invalidateInvalid$11((Session)session, exchange));
        ((SessionConfig)Mockito.verify((Object)this.config)).clearSession(exchange, sessionId);
        ((Batch)Mockito.verify((Object)batch)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(exchange);
    }

    @Test
    public void getSessionManager() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        Assert.assertSame((Object)this.manager, (Object)session.getSessionManager());
    }

    @Test
    public void changeSessionId() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        HttpServerExchange exchange = new HttpServerExchange(null);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier identifierFactory = (Supplier)Mockito.mock(Supplier.class);
        org.wildfly.clustering.session.Session newSession = (org.wildfly.clustering.session.Session)Mockito.mock(org.wildfly.clustering.session.Session.class);
        Map oldAttributes = (Map)Mockito.mock(Map.class);
        Map newAttributes = (Map)Mockito.mock(Map.class);
        SessionMetaData oldMetaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionMetaData newMetaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        HashMap<String, String> oldContext = new HashMap<String, String>();
        oldContext.put("foo", "bar");
        HashMap newContext = new HashMap();
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        String oldSessionId = "old";
        String newSessionId = "new";
        Instant now = Instant.now();
        Duration interval = Duration.ofSeconds(10L);
        ((SuspendedBatch)Mockito.doReturn((Object)context).when((Object)this.suspendedBatch)).resumeWithContext();
        ((UndertowSessionManager)Mockito.doReturn((Object)manager).when((Object)this.manager)).getSessionManager();
        ((SessionManager)Mockito.doReturn((Object)identifierFactory).when((Object)manager)).getIdentifierFactory();
        ((Supplier)Mockito.doReturn((Object)newSessionId).when((Object)identifierFactory)).get();
        ((SessionManager)Mockito.doReturn((Object)newSession).when((Object)manager)).createSession(newSessionId);
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)oldAttributes).when(this.session)).getAttributes();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)oldMetaData).when(this.session)).getMetaData();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)newAttributes).when((Object)newSession)).getAttributes();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)newMetaData).when((Object)newSession)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)now).when((Object)oldMetaData)).getLastAccessStartTime();
        ((SessionMetaData)Mockito.doReturn((Object)now).when((Object)oldMetaData)).getLastAccessEndTime();
        ((SessionMetaData)Mockito.doReturn((Object)interval).when((Object)oldMetaData)).getTimeout();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)oldSessionId).when(this.session)).getId();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)newSessionId).when((Object)newSession)).getId();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn(oldContext).when(this.session)).getContext();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn(newContext).when((Object)newSession)).getContext();
        ((UndertowSessionManager)Mockito.doReturn((Object)listeners).when((Object)this.manager)).getSessionListeners();
        String result = session.changeSessionId(exchange, config);
        Assert.assertSame((Object)newSessionId, (Object)result);
        ((SessionMetaData)Mockito.verify((Object)newMetaData)).setLastAccess(now, now);
        ((SessionMetaData)Mockito.verify((Object)newMetaData)).setTimeout(interval);
        ((Map)Mockito.verify((Object)newAttributes)).putAll(oldAttributes);
        ((SessionConfig)Mockito.verify((Object)config)).setSessionId(exchange, newSessionId);
        Assert.assertEquals(oldContext, newContext);
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).invalidate();
        ((org.wildfly.clustering.session.Session)Mockito.verify((Object)newSession, (VerificationMode)Mockito.never())).invalidate();
        ((SessionListener)Mockito.verify((Object)listener)).sessionIdChanged((Session)session, oldSessionId);
        ((SuspendedBatch)Mockito.verify((Object)this.suspendedBatch)).resumeWithContext();
        ((BatchContext)Mockito.verify((Object)context)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.suspendedBatch});
    }

    public void changeSessionIdResponseCommitted() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)true).when(this.session)).isValid();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        Configurable configurable = (Configurable)Mockito.mock(Configurable.class);
        StreamSourceConduit sourceConduit = (StreamSourceConduit)Mockito.mock(StreamSourceConduit.class);
        ConduitStreamSourceChannel sourceChannel = new ConduitStreamSourceChannel(configurable, sourceConduit);
        StreamSinkConduit sinkConduit = (StreamSinkConduit)Mockito.mock(StreamSinkConduit.class);
        ConduitStreamSinkChannel sinkChannel = new ConduitStreamSinkChannel(configurable, sinkConduit);
        StreamConnection stream = (StreamConnection)Mockito.mock(StreamConnection.class);
        ((StreamConnection)Mockito.doReturn((Object)sourceChannel).when((Object)stream)).getSourceChannel();
        ((StreamConnection)Mockito.doReturn((Object)sinkChannel).when((Object)stream)).getSinkChannel();
        ByteBufferPool bufferPool = (ByteBufferPool)Mockito.mock(ByteBufferPool.class);
        HttpHandler handler = (HttpHandler)Mockito.mock(HttpHandler.class);
        HttpServerConnection connection = new HttpServerConnection(stream, bufferPool, handler, OptionMap.create((Option)UndertowOptions.ALWAYS_SET_DATE, (Object)false), 0, null);
        HttpServerExchange exchange = new HttpServerExchange((ServerConnection)connection);
        exchange.setProtocol(Protocols.HTTP_1_1);
        exchange.getResponseChannel();
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$changeSessionIdResponseCommitted$12((Session)session, exchange, config));
    }

    @Test
    public void changeSessionIdConcurrentInvalidate() {
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)this.metaData).when(this.session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)false).when((Object)this.metaData)).isNew();
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.suspendedBatch, this.closeTask, this.statistics);
        HttpServerExchange exchange = new HttpServerExchange(null);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier identifierFactory = (Supplier)Mockito.mock(Supplier.class);
        org.wildfly.clustering.session.Session newSession = (org.wildfly.clustering.session.Session)Mockito.mock(org.wildfly.clustering.session.Session.class);
        Map oldAttributes = (Map)Mockito.mock(Map.class);
        Map newAttributes = (Map)Mockito.mock(Map.class);
        SessionMetaData oldMetaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionMetaData newMetaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        HashMap<String, String> oldContext = new HashMap<String, String>();
        oldContext.put("foo", "bar");
        HashMap newContext = new HashMap();
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        String oldSessionId = "old";
        String newSessionId = "new";
        Instant now = Instant.now();
        Duration interval = Duration.ofSeconds(10L);
        ((SuspendedBatch)Mockito.doReturn((Object)context).when((Object)this.suspendedBatch)).resumeWithContext();
        ((UndertowSessionManager)Mockito.doReturn((Object)manager).when((Object)this.manager)).getSessionManager();
        ((SessionManager)Mockito.doReturn((Object)identifierFactory).when((Object)manager)).getIdentifierFactory();
        ((Supplier)Mockito.doReturn((Object)newSessionId).when((Object)identifierFactory)).get();
        ((SessionManager)Mockito.doReturn((Object)newSession).when((Object)manager)).createSession(newSessionId);
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)oldAttributes).when(this.session)).getAttributes();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)oldMetaData).when(this.session)).getMetaData();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)newAttributes).when((Object)newSession)).getAttributes();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)newMetaData).when((Object)newSession)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)now).when((Object)oldMetaData)).getLastAccessStartTime();
        ((SessionMetaData)Mockito.doReturn((Object)now).when((Object)oldMetaData)).getLastAccessEndTime();
        ((SessionMetaData)Mockito.doReturn((Object)interval).when((Object)oldMetaData)).getTimeout();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)oldSessionId).when(this.session)).getId();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn((Object)newSessionId).when((Object)newSession)).getId();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn(oldContext).when(this.session)).getContext();
        ((org.wildfly.clustering.session.Session)Mockito.doReturn(newContext).when((Object)newSession)).getContext();
        ((org.wildfly.clustering.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).invalidate();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$changeSessionIdConcurrentInvalidate$13((Session)session, exchange, config));
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).sessionIdChanged((Session)session, oldSessionId);
        ((org.wildfly.clustering.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(exchange);
        ((org.wildfly.clustering.session.Session)Mockito.verify((Object)newSession)).invalidate();
        ((SuspendedBatch)Mockito.verify((Object)this.suspendedBatch)).resumeWithContext();
        ((BatchContext)Mockito.verify((Object)context)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.suspendedBatch});
    }

    private static /* synthetic */ void lambda$changeSessionIdConcurrentInvalidate$13(Session session, HttpServerExchange exchange, SessionConfig config) throws Throwable {
        session.changeSessionId(exchange, config);
    }

    private static /* synthetic */ void lambda$changeSessionIdResponseCommitted$12(Session session, HttpServerExchange exchange, SessionConfig config) throws Throwable {
        session.changeSessionId(exchange, config);
    }

    private static /* synthetic */ void lambda$invalidateInvalid$11(Session session, HttpServerExchange exchange) throws Throwable {
        session.invalidate(exchange);
    }

    private static /* synthetic */ void lambda$removeAuthenticatedSessionAttribute$10(Session session, String name) throws Throwable {
        session.removeAttribute(name);
    }

    private static /* synthetic */ void lambda$removeAttribute$9(Session session, String name) throws Throwable {
        session.removeAttribute(name);
    }

    private static /* synthetic */ void lambda$setAuthenticatedSessionAttribute$8(Session session, String name, AuthenticatedSessionManager.AuthenticatedSession oldAuth) throws Throwable {
        session.setAttribute(name, (Object)oldAuth);
    }

    private static /* synthetic */ void lambda$setAttribute$7(Session session, String name, Integer value) throws Throwable {
        session.setAttribute(name, (Object)value);
    }

    private static /* synthetic */ void lambda$getAuthenticatedSessionAttribute$6(Session session, String name) throws Throwable {
        session.getAttribute(name);
    }

    private static /* synthetic */ void lambda$getAttribute$5(Session session, String name) throws Throwable {
        session.getAttribute(name);
    }

    private static /* synthetic */ void lambda$getAttributeNames$4(Session session) throws Throwable {
        session.getAttributeNames();
    }

    private static /* synthetic */ void lambda$setMaxInactiveInterval$3(Session session, int interval) throws Throwable {
        session.setMaxInactiveInterval(interval);
    }

    private static /* synthetic */ void lambda$getMaxInactiveInterval$2(Session session) throws Throwable {
        session.getMaxInactiveInterval();
    }

    private static /* synthetic */ void lambda$getLastAccessedTime$1(Session session) throws Throwable {
        session.getLastAccessedTime();
    }

    private static /* synthetic */ void lambda$getCreationTime$0(Session session) throws Throwable {
        session.getCreationTime();
    }
}

