/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.config.assembly;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.config.assembly.SubsystemConfig;

class SubsystemsParser {
    static String NAMESPACE = "urn:subsystems-config:1.0";
    private final File inputFile;
    Map<String, SubsystemConfig[]> subsystemConfigs = new HashMap<String, SubsystemConfig[]>();

    SubsystemsParser(File inputFile) {
        this.inputFile = inputFile;
    }

    Map<String, SubsystemConfig[]> getSubsystemConfigs() {
        return this.subsystemConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse() throws IOException, XMLStreamException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.inputFile));
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(in);
            reader.require(7, null, null);
            boolean done = false;
            while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if (!done && reader.getLocalName().equals("config")) {
                            this.parseSubsystems(reader);
                            done = true;
                            break;
                        }
                        throw new XMLStreamException("Invalid element " + reader.getLocalName(), reader.getLocation());
                    }
                    case 8: {
                        return;
                    }
                }
            }
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception ignore) {}
        }
    }

    private void parseSubsystems(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    if (reader.getLocalName().equals("subsystems")) {
                        String name = "";
                        for (int i = 0; i < reader.getAttributeCount(); ++i) {
                            if (!reader.getAttributeLocalName(i).equals("name")) {
                                throw new XMLStreamException("Unknown attribute " + reader.getAttributeLocalName(i), reader.getLocation());
                            }
                            name = reader.getAttributeValue(i);
                        }
                        if (this.subsystemConfigs.containsKey(name)) {
                            throw new XMLStreamException("Already have a subsystems named " + name, reader.getLocation());
                        }
                        ArrayList<SubsystemConfig> subsystems = new ArrayList<SubsystemConfig>();
                        this.parseSubsystem(reader, subsystems);
                        this.subsystemConfigs.put(name, subsystems.toArray(new SubsystemConfig[subsystems.size()]));
                        break;
                    }
                    throw new XMLStreamException("Invalid element " + reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    if (!reader.getLocalName().equals("config")) break;
                    return;
                }
            }
        }
    }

    private void parseSubsystem(XMLStreamReader reader, List<SubsystemConfig> subsystems) throws XMLStreamException {
        reader.next();
        block4: while (true) {
            switch (reader.getEventType()) {
                case 1: {
                    if (reader.getLocalName().equals("subsystem")) {
                        String supplement = null;
                        String systemProperty = null;
                        for (int i = 0; i < reader.getAttributeCount(); ++i) {
                            String attr = reader.getAttributeLocalName(i);
                            if (attr.equals("supplement")) {
                                supplement = reader.getAttributeValue(i);
                                continue;
                            }
                            if (attr.equals("include-if-set")) {
                                systemProperty = reader.getAttributeValue(i);
                                continue;
                            }
                            throw new XMLStreamException("Unknown attribute " + attr, reader.getLocation());
                        }
                        String text = reader.getElementText();
                        if (systemProperty != null) {
                            if (System.getProperty(systemProperty) == null) continue block4;
                            subsystems.add(new SubsystemConfig(text, supplement));
                            continue block4;
                        }
                        subsystems.add(new SubsystemConfig(text, supplement));
                        continue block4;
                    }
                    throw new XMLStreamException("Invalid element " + reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    if (!reader.getLocalName().equals("subsystems")) break;
                    return;
                }
            }
            reader.next();
        }
    }
}

