/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.List;
import javax.sql.DataSource;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.datasources.statistics.DataSourceStatisticsService;
import org.jboss.as.connector.subsystems.datasources.CommonDeploymentService;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.DataSourceEnable;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.connector.subsystems.datasources.XADataSourceConfigService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class DataSourceDisable
implements OperationStepHandler {
    static final DataSourceDisable LOCAL_INSTANCE = new DataSourceDisable(false);
    static final DataSourceDisable XA_INSTANCE = new DataSourceDisable(true);
    private final boolean xa;

    public DataSourceDisable(boolean xa) {
        this.xa = xa;
    }

    public void execute(OperationContext context, ModelNode operation) {
        final ManagementResourceRegistration datasourceRegistration = context.getResourceRegistrationForUpdate();
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        final ModelNode model = resource.getModel();
        model.get("enabled").set(false);
        if (context.isNormalServer()) {
            DataSourceStatisticsService.removeStatisticsResources(resource);
            if (context.isResourceServiceRestartAllowed()) {
                context.addStep(new OperationStepHandler(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        ServiceName binderServiceName;
                        ServiceController binderController;
                        ServiceName dataSourceServiceName;
                        ModelNode address = operation.require("address");
                        String dsName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
                        String jndiName = Constants.JNDI_NAME.resolveModelAttribute(context, model).asString();
                        ServiceRegistry registry = context.getServiceRegistry(true);
                        ServiceController dataSourceController = registry.getService(dataSourceServiceName = context.getCapabilityServiceName("org.wildfly.data-source", dsName, DataSource.class));
                        if (dataSourceController == null) throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.serviceNotAvailable("Data-source", dsName));
                        if (!ServiceController.State.UP.equals((Object)dataSourceController.getState())) {
                            throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.serviceNotEnabled("Data-source", dsName));
                        }
                        dataSourceController.setMode(ServiceController.Mode.NEVER);
                        context.removeService(CommonDeploymentService.SERVICE_NAME_BASE.append(new String[]{jndiName}));
                        context.removeService(dataSourceServiceName.append(new String[]{"statistics"}));
                        ServiceName referenceServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{dsName});
                        ServiceController referenceController = registry.getService(referenceServiceName);
                        if (referenceController != null) {
                            context.removeService(referenceController);
                        }
                        if ((binderController = registry.getService(binderServiceName = ContextNames.bindInfoFor((String)jndiName).getBinderServiceName())) != null) {
                            context.removeService(binderController);
                        }
                        ServiceName dataSourceConfigServiceName = DataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName});
                        ServiceController dataSourceConfigController = registry.getService(dataSourceConfigServiceName);
                        List serviceNames = registry.getServiceNames();
                        ServiceName xaDataSourceConfigServiceName = XADataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName});
                        ServiceController xaDataSourceConfigController = registry.getService(xaDataSourceConfigServiceName);
                        for (ServiceName name : serviceNames) {
                            if (dataSourceConfigServiceName.append(new String[]{"connection-properties"}).isParentOf(name)) {
                                ServiceController connPropertyController = registry.getService(name);
                                if (connPropertyController == null) throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.serviceNotAvailable("Data-source.connectionProperty", name));
                                if (!ServiceController.State.UP.equals((Object)connPropertyController.getState())) throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.serviceAlreadyStarted("Data-source.connectionProperty", name));
                                connPropertyController.setMode(ServiceController.Mode.NEVER);
                            }
                            if (!xaDataSourceConfigServiceName.append(new String[]{"xa-datasource-properties"}).isParentOf(name)) continue;
                            ServiceController xaConfigPropertyController = registry.getService(name);
                            if (xaConfigPropertyController == null) throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.serviceNotAvailable("Data-source.xa-config-property", name));
                            if (!ServiceController.State.UP.equals((Object)xaConfigPropertyController.getState())) throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.serviceAlreadyStarted("Data-source.xa-config-property", name));
                            xaConfigPropertyController.setMode(ServiceController.Mode.NEVER);
                        }
                        if (xaDataSourceConfigController != null) {
                            context.removeService(xaDataSourceConfigController);
                        }
                        if (dataSourceConfigController != null) {
                            context.removeService(dataSourceConfigController);
                        }
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                try {
                                    DataSourceDisable.this.reEnable(context, operation, datasourceRegistration);
                                }
                                catch (OperationFailedException operationFailedException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            } else {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        context.reloadRequired();
                        context.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
        context.stepCompleted();
    }

    private void reEnable(OperationContext context, ModelNode operation, ManagementResourceRegistration datasourceRegistration) throws OperationFailedException {
        if (context.isNormalServer()) {
            PathAddress addr = PathAddress.pathAddress((ModelNode)operation.get("address"));
            Resource resource = context.getOriginalRootResource();
            for (PathElement element : addr) {
                resource = resource.getChild(element);
            }
            DataSourceEnable.addServices(context, operation, datasourceRegistration, Resource.Tools.readModel((Resource)resource), this.isXa());
        }
    }

    public boolean isXa() {
        return this.xa;
    }
}

