/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.regex.Pattern;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ExpressionResolverImpl;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public interface ExpressionResolver {
    public static final Pattern EXPRESSION_PATTERN = Pattern.compile(".*\\$\\{.*\\}.*");
    public static final ExpressionResolver TEST_RESOLVER;
    @Deprecated
    public static final ExpressionResolver DEFAULT;
    public static final ExpressionResolver REJECTING;

    public ModelNode resolveExpressions(ModelNode var1) throws OperationFailedException;

    static {
        DEFAULT = TEST_RESOLVER = new ExpressionResolverImpl();
        REJECTING = new ExpressionResolverImpl(){

            @Override
            protected void resolvePluggableExpression(ModelNode node) throws OperationFailedException {
                String expression = node.asString();
                if (EXPRESSION_PATTERN.matcher(expression).matches()) {
                    throw ControllerMessages.MESSAGES.illegalUnresolvedModel(expression);
                }
                node.set(expression);
            }
        };
    }
}

