/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.remote.RemoteProxyController;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.remote.TransactionalProtocolHandlers;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.dmr.ModelNode;

public interface TransformingProxyController
extends ProxyController {
    public TransactionalProtocolClient getProtocolClient();

    public Transformers getTransformers();

    public OperationTransformer.TransformedOperation transformOperation(OperationContext var1, ModelNode var2) throws OperationFailedException;

    public static class TransformingProxyControllerImpl
    implements TransformingProxyController {
        private final RemoteProxyController proxy;
        private final Transformers transformers;

        public TransformingProxyControllerImpl(Transformers transformers, RemoteProxyController proxy) {
            this.transformers = transformers;
            this.proxy = proxy;
        }

        @Override
        public TransactionalProtocolClient getProtocolClient() {
            return this.proxy.getTransactionalProtocolClient();
        }

        @Override
        public Transformers getTransformers() {
            return this.transformers;
        }

        @Override
        public PathAddress getProxyNodeAddress() {
            return this.proxy.getProxyNodeAddress();
        }

        @Override
        public OperationTransformer.TransformedOperation transformOperation(OperationContext context, ModelNode operation) throws OperationFailedException {
            return this.transformers.transformOperation(context, operation);
        }

        @Override
        public void execute(ModelNode operation, OperationMessageHandler handler, ProxyController.ProxyOperationControl control, OperationAttachments attachments) {
            this.proxy.execute(operation, handler, control, attachments);
        }
    }

    public static class Factory {
        public static TransformingProxyController create(ManagementChannelHandler channelAssociation, Transformers transformers, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator, boolean validateAddresses) {
            TransactionalProtocolClient client = TransactionalProtocolHandlers.createClient(channelAssociation);
            return Factory.create(client, transformers, pathAddress, addressTranslator, validateAddresses);
        }

        public static TransformingProxyController create(TransactionalProtocolClient client, final Transformers transformers, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator, boolean validateAddresses) {
            final RemoteProxyController proxy = RemoteProxyController.create(client, pathAddress, addressTranslator, validateAddresses);
            Transformers delegating = new Transformers(){

                @Override
                public TransformationTarget getTarget() {
                    return transformers.getTarget();
                }

                @Override
                public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, ModelNode original) throws OperationFailedException {
                    ModelNode operation = proxy.translateOperationForProxy(original);
                    return transformers.transformOperation(context, operation);
                }

                @Override
                public Resource transformResource(ResourceTransformationContext context, Resource resource) throws OperationFailedException {
                    return transformers.transformResource(context, resource);
                }

                @Override
                public OperationTransformer.TransformedOperation transformOperation(OperationContext operationContext, ModelNode original) throws OperationFailedException {
                    ModelNode operation = proxy.translateOperationForProxy(original);
                    return transformers.transformOperation(operationContext, operation);
                }

                @Override
                public Resource transformRootResource(OperationContext operationContext, Resource resource) throws OperationFailedException {
                    return transformers.transformRootResource(operationContext, resource);
                }

                @Override
                public Resource transformResource(OperationContext operationContext, PathAddress original, Resource resource, boolean skipRuntimeIgnoreCheck) throws OperationFailedException {
                    return transformers.transformResource(operationContext, original, resource, skipRuntimeIgnoreCheck);
                }
            };
            return Factory.create(proxy, delegating);
        }

        private static TransformingProxyController create(RemoteProxyController delegate, Transformers transformers) {
            return new TransformingProxyControllerImpl(transformers, delegate);
        }
    }
}

