/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import org.jboss.as.domain.http.server.security.RealmIdentityManager;
import org.jboss.as.domain.management.AuthMechanism;

public class AuthenticationMechanismWrapper
implements AuthenticationMechanism {
    private final AuthenticationMechanism wrapped;
    private final AuthMechanism mechanism;

    public AuthenticationMechanismWrapper(AuthenticationMechanism wrapped, AuthMechanism mechanism) {
        this.wrapped = wrapped;
        this.mechanism = mechanism;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        try {
            RealmIdentityManager.setAuthenticationMechanism(this.mechanism);
            AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = this.wrapped.authenticate(exchange, securityContext);
            return authenticationMechanismOutcome;
        }
        finally {
            RealmIdentityManager.setAuthenticationMechanism(null);
        }
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return this.wrapped.sendChallenge(exchange, securityContext);
    }
}

