/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.jboss.as.domain.http.server.Common;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.as.domain.http.server.OperationParameter;
import org.jboss.dmr.ModelNode;
import org.xnio.IoUtils;
import org.xnio.streams.ChannelOutputStream;

public class DomainUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeResponse(HttpServerExchange exchange, int status, ModelNode response, OperationParameter operationParameter) {
        exchange.setResponseCode(status);
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        String contentType = operationParameter.isEncode() ? "application/dmr-encoded" : "application/json";
        responseHeaders.put(Headers.CONTENT_TYPE, contentType + ";" + Common.UTF_8);
        DomainUtil.writeCacheHeaders(exchange, status, operationParameter);
        if (operationParameter.isGet() && status == 200) {
            response = response.get("result");
            try {
                int length = DomainUtil.getResponseLength(response, operationParameter);
                responseHeaders.put(Headers.CONTENT_LENGTH, (long)length);
            }
            catch (IOException e) {
                HttpServerLogger.ROOT_LOGGER.errorf(e, "Unable to get length for '%s'", operationParameter);
            }
        }
        ChannelOutputStream out = new ChannelOutputStream(exchange.getResponseChannel());
        PrintWriter print = new PrintWriter((OutputStream)out);
        try {
            try {
                if (operationParameter.isEncode()) {
                    response.writeBase64((OutputStream)out);
                } else {
                    response.writeJSONString(print, !operationParameter.isPretty());
                }
            }
            finally {
                print.flush();
                try {
                    out.flush();
                }
                finally {
                    IoUtils.safeClose((Closeable)print);
                    IoUtils.safeClose((Closeable)out);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getResponseLength(ModelNode modelNode, OperationParameter operationParameter) throws IOException {
        int length;
        if (operationParameter.isEncode()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream out = new BufferedOutputStream(baos);
            modelNode.writeBase64((OutputStream)out);
            out.flush();
            length = baos.size();
            IoUtils.safeClose((Closeable[])new Closeable[]{out, baos});
        } else {
            String json = modelNode.toJSONString(!operationParameter.isPretty());
            length = json.length();
        }
        return length;
    }

    public static void writeCacheHeaders(HttpServerExchange exchange, int status, OperationParameter operationParameter) {
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        if (operationParameter.getMaxAge() > 0 && status != 304) {
            responseHeaders.put(Headers.CACHE_CONTROL, "max-age=" + operationParameter.getMaxAge() + ", private, must-revalidate");
        }
        if (operationParameter.getEtag() != null) {
            responseHeaders.put(Headers.ETAG, operationParameter.getEtag().toString());
        }
    }

    public static String constructUrl(HttpServerExchange exchange, String path) {
        HeaderMap headers = exchange.getRequestHeaders();
        String host = headers.getFirst(Headers.HOST);
        String protocol = exchange.getConnection().getSslSessionInfo() != null ? "https" : "http";
        return protocol + "://" + host + path;
    }
}

