/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.DigestCredential;
import io.undertow.security.idm.GSSContextCredential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.security.idm.X509CertificateCredential;
import io.undertow.util.HexConverter;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.ietf.jgss.GSSException;
import org.jboss.as.controller.security.InetAddressPrincipal;
import org.jboss.as.core.security.SimplePrincipal;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;
import org.jboss.as.domain.http.server.security.RealmIdentityAccount;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.SubjectIdentity;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.interfaces.DigestPassword;

@Deprecated
public class RealmIdentityManager
implements IdentityManager {
    private static final ThreadLocal<ThreadLocalStore> requestSpecific = new ThreadLocal();
    private final SecurityRealm securityRealm;

    static void setRequestSpecific(AuthMechanism mechanism, InetAddress clientAddress) {
        ThreadLocalStore store = new ThreadLocalStore();
        store.requestMechanism = mechanism;
        store.inetAddress = clientAddress;
        requestSpecific.set(store);
    }

    static void clearRequestSpecific() {
        ThreadLocalStore store = requestSpecific.get();
        if (store != null && store.subjectIdentity != null) {
            store.subjectIdentity.logout();
        }
        requestSpecific.set(null);
    }

    private AuthMechanism getRequestMeschanism() {
        ThreadLocalStore store = requestSpecific.get();
        return store == null ? null : store.requestMechanism;
    }

    private InetAddress getInetAddress() {
        ThreadLocalStore store = requestSpecific.get();
        return store == null ? null : store.inetAddress;
    }

    void setCurrentSubjectIdentity(SubjectIdentity subjectIdentity) {
        RealmIdentityManager.requestSpecific.get().subjectIdentity = subjectIdentity;
    }

    public RealmIdentityManager(SecurityRealm securityRealm) {
        this.securityRealm = securityRealm;
    }

    public Account verify(Account account) {
        return account;
    }

    private boolean plainTextDigest() {
        Map mechConfig = this.securityRealm.getMechanismConfig(AuthMechanism.DIGEST);
        boolean plainTextDigest = true;
        if (mechConfig.containsKey("org.jboss.as.domain.management.digest.plain_text")) {
            plainTextDigest = Boolean.parseBoolean((String)mechConfig.get("org.jboss.as.domain.management.digest.plain_text"));
        }
        return plainTextDigest;
    }

    public Account verify(String id, Credential credential) {
        if (id == null || id.length() == 0) {
            HttpServerLogger.ROOT_LOGGER.debug("Missing or empty username received, aborting account verification.");
            return null;
        }
        if (credential instanceof PasswordCredential) {
            return this.verify(id, (PasswordCredential)credential);
        }
        if (credential instanceof DigestCredential) {
            return this.verify(id, (DigestCredential)credential);
        }
        throw HttpServerLogger.ROOT_LOGGER.invalidCredentialType(credential.getClass().getName());
    }

    private Account verify(String id, PasswordCredential credential) {
        SubjectUserInfo supplemental;
        this.assertMechanism(AuthMechanism.PLAIN);
        if (credential == null) {
            return null;
        }
        AuthorizingCallbackHandler ach = this.securityRealm.getAuthorizingCallbackHandler(AuthMechanism.PLAIN);
        Callback[] callbacks = new Callback[]{new RealmCallback("Realm", this.securityRealm.getName()), new NameCallback("Username", id), new EvidenceVerifyCallback((Evidence)new PasswordGuessEvidence(credential.getPassword()))};
        try {
            ach.handle(callbacks);
        }
        catch (Exception e) {
            HttpServerLogger.ROOT_LOGGER.debug("Failure handling Callback(s) for BASIC authentication.", e);
            return null;
        }
        if (!((EvidenceVerifyCallback)callbacks[2]).isVerified()) {
            return null;
        }
        SimplePrincipal user = new SimplePrincipal(id);
        Set<SimplePrincipal> userCol = Collections.singleton(user);
        try {
            supplemental = ach.createSubjectUserInfo(userCol);
        }
        catch (IOException e) {
            return null;
        }
        this.addInetPrincipal(supplemental.getSubject().getPrincipals());
        return new RealmIdentityAccount(supplemental.getSubject(), (Principal)user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Account verify(String id, DigestCredential credential) {
        byte[] ha1;
        this.assertMechanism(AuthMechanism.DIGEST);
        AuthorizingCallbackHandler ach = this.securityRealm.getAuthorizingCallbackHandler(AuthMechanism.DIGEST);
        Callback[] callbacks = new Callback[3];
        callbacks[0] = new RealmCallback("Realm", credential.getRealm());
        callbacks[1] = new NameCallback("Username", id);
        boolean plainText = this.plainTextDigest();
        callbacks[2] = plainText ? new PasswordCallback("Password", false) : new CredentialCallback(org.wildfly.security.credential.PasswordCredential.class, "digest-md5");
        try {
            ach.handle(callbacks);
        }
        catch (Exception e) {
            HttpServerLogger.ROOT_LOGGER.debug("Failure handling Callback(s) for BASIC authentication.", e);
            return null;
        }
        if (plainText) {
            MessageDigest digest = null;
            try {
                digest = credential.getAlgorithm().getMessageDigest();
                digest.update(id.getBytes(StandardCharsets.UTF_8));
                digest.update((byte)58);
                digest.update(credential.getRealm().getBytes(StandardCharsets.UTF_8));
                digest.update((byte)58);
                digest.update(new String(((PasswordCallback)callbacks[2]).getPassword()).getBytes(StandardCharsets.UTF_8));
                ha1 = HexConverter.convertToHexBytes((byte[])digest.digest());
            }
            catch (NoSuchAlgorithmException e) {
                HttpServerLogger.ROOT_LOGGER.debug("Unexpected authentication failure", e);
                Account account = null;
                return account;
            }
            finally {
                digest.reset();
            }
        } else {
            org.wildfly.security.credential.PasswordCredential passwordCredential = (org.wildfly.security.credential.PasswordCredential)((CredentialCallback)callbacks[2]).getCredential();
            DigestPassword digestPassword = (DigestPassword)passwordCredential.getPassword(DigestPassword.class);
            ha1 = ByteIterator.ofBytes((byte[])digestPassword.getDigest()).hexEncode().drainToString().getBytes(StandardCharsets.US_ASCII);
        }
        try {
            if (credential.verifyHA1(ha1)) {
                SimplePrincipal user = new SimplePrincipal(id);
                Set<SimplePrincipal> userCol = Collections.singleton(user);
                SubjectUserInfo supplemental = ach.createSubjectUserInfo(userCol);
                this.addInetPrincipal(supplemental.getSubject().getPrincipals());
                return new RealmIdentityAccount(supplemental.getSubject(), (Principal)user);
            }
        }
        catch (IOException e) {
            HttpServerLogger.ROOT_LOGGER.debug("Unexpected authentication failure", e);
        }
        return null;
    }

    public Account verify(Credential credential) {
        SubjectUserInfo supplemental;
        Principal user;
        AuthorizingCallbackHandler ach;
        this.assertMechanism(AuthMechanism.CLIENT_CERT, AuthMechanism.KERBEROS);
        if (credential instanceof X509CertificateCredential) {
            X509CertificateCredential certCred = (X509CertificateCredential)credential;
            ach = this.securityRealm.getAuthorizingCallbackHandler(AuthMechanism.CLIENT_CERT);
            user = certCred.getCertificate().getSubjectDN();
        } else if (credential instanceof GSSContextCredential) {
            GSSContextCredential gssCred = (GSSContextCredential)credential;
            try {
                user = new KerberosPrincipal(gssCred.getGssContext().getSrcName().toString());
            }
            catch (GSSException e) {
                HttpServerLogger.ROOT_LOGGER.debug("Unexpected authentication failure", e);
                return null;
            }
            ach = this.securityRealm.getAuthorizingCallbackHandler(AuthMechanism.KERBEROS);
        } else {
            return null;
        }
        try {
            ach.handle(new Callback[]{new AuthorizeCallback(user.getName(), user.getName())});
        }
        catch (IOException e) {
            HttpServerLogger.ROOT_LOGGER.debug("Unexpected authentication failure", e);
            return null;
        }
        catch (UnsupportedCallbackException e) {
            HttpServerLogger.ROOT_LOGGER.debug("Unexpected authentication failure", e);
            return null;
        }
        Set<Principal> userCol = Collections.singleton(user);
        try {
            supplemental = ach.createSubjectUserInfo(userCol);
        }
        catch (IOException e) {
            return null;
        }
        this.addInetPrincipal(supplemental.getSubject().getPrincipals());
        return new RealmIdentityAccount(supplemental.getSubject(), user);
    }

    private void addInetPrincipal(Collection<Principal> principals) {
        InetAddress address = this.getInetAddress();
        if (address != null) {
            principals.add((Principal)new InetAddressPrincipal(address));
        }
    }

    private void assertMechanism(AuthMechanism ... mechanisms) {
        AuthMechanism requested = this.getRequestMeschanism();
        for (AuthMechanism current : mechanisms) {
            if (requested != current) continue;
            return;
        }
        throw new IllegalStateException("Unexpected authentication mechanism executing.");
    }

    private static final class ThreadLocalStore {
        AuthMechanism requestMechanism;
        InetAddress inetAddress;
        SubjectIdentity subjectIdentity;

        private ThreadLocalStore() {
        }
    }
}

