/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.marshalling;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.io.ExposedByteArrayOutputStream;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.MarshallableTypeHints;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamAwareMarshaller;

public abstract class AbstractMarshaller
implements Marshaller,
StreamAwareMarshaller {
    private final MarshallableTypeHints hints = new MarshallableTypeHints();

    public void stop() {
        this.hints.clear();
    }

    public int sizeEstimate(Object object) {
        return this.getBufferSizePredictor(object).nextSize(object);
    }

    public BufferSizePredictor getBufferSizePredictor(Object object) {
        return this.hints.getBufferSizePredictor(object);
    }

    public Object objectFromByteBuffer(byte[] bytes) throws IOException, ClassNotFoundException {
        return this.objectFromByteBuffer(bytes, 0, bytes.length);
    }

    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        ByteArrayInputStream input = new ByteArrayInputStream(buf, offset, length);
        return this.readObject(input);
    }

    public byte[] objectToByteBuffer(Object object) throws IOException, InterruptedException {
        if (object == null) {
            return this.objectToByteBuffer(null, 1);
        }
        int estimatedSize = this.sizeEstimate(object);
        byte[] bytes = this.objectToByteBuffer(object, estimatedSize);
        int actualSize = bytes.length - 1;
        this.getBufferSizePredictor(object).recordSize(actualSize);
        return bytes;
    }

    public ByteBuffer objectToBuffer(Object object) throws IOException {
        ByteBuffer buffer;
        int actualSize;
        if (object == null) {
            return this.objectToBuffer(null, 1);
        }
        int estimatedSize = this.sizeEstimate(object);
        if (estimatedSize > (actualSize = (buffer = this.objectToBuffer(object, estimatedSize)).getLength() - 1) * 4) {
            byte[] bytes = AbstractMarshaller.trim(buffer);
            buffer = new ByteBufferImpl(bytes, 0, bytes.length);
        }
        this.getBufferSizePredictor(object).recordSize(actualSize);
        return buffer;
    }

    public byte[] objectToByteBuffer(Object obj, int estimatedSize) throws IOException, InterruptedException {
        ByteBuffer b = this.objectToBuffer(obj, estimatedSize);
        return AbstractMarshaller.trim(b);
    }

    private ByteBuffer objectToBuffer(Object object, int estimatedSize) throws IOException {
        ExposedByteArrayOutputStream output = new ExposedByteArrayOutputStream(estimatedSize + 1);
        this.writeObject(object, (OutputStream)output);
        return new ByteBufferImpl(output.getRawBuffer(), 0, output.size());
    }

    private static byte[] trim(ByteBuffer buffer) {
        byte[] bytes = buffer.getBuf();
        int offset = buffer.getOffset();
        int length = buffer.getLength();
        if (offset == 0 && bytes.length == length) {
            return bytes;
        }
        byte[] result = new byte[length];
        System.arraycopy(bytes, offset, result, 0, length);
        return result;
    }
}

