/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.manager;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import javax.transaction.Transaction;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.BatchModification;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.reactivestreams.Publisher;

public interface PersistenceManager
extends Lifecycle {
    public boolean isEnabled();

    public boolean hasWriter();

    public boolean isPreloaded();

    public CompletionStage<Void> preload();

    public void disableStore(String var1);

    public <T> Set<T> getStores(Class<T> var1);

    public Collection<String> getStoresAsString();

    public void purgeExpired();

    public CompletionStage<Void> clearAllStores(Predicate<? super StoreConfiguration> var1);

    @Deprecated
    public boolean deleteFromAllStoresSync(Object var1, int var2, Predicate<? super StoreConfiguration> var3);

    public CompletionStage<Boolean> deleteFromAllStores(Object var1, int var2, Predicate<? super StoreConfiguration> var3);

    default public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(boolean fetchValue, boolean fetchMetadata) {
        return this.publishEntries(null, fetchValue, fetchMetadata, AccessMode.BOTH);
    }

    public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(Predicate<? super K> var1, boolean var2, boolean var3, Predicate<? super StoreConfiguration> var4);

    public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(IntSet var1, Predicate<? super K> var2, boolean var3, boolean var4, Predicate<? super StoreConfiguration> var5);

    public <K> Publisher<K> publishKeys(Predicate<? super K> var1, Predicate<? super StoreConfiguration> var2);

    public <K> Publisher<K> publishKeys(IntSet var1, Predicate<? super K> var2, Predicate<? super StoreConfiguration> var3);

    public <K, V> CompletionStage<MarshallableEntry<K, V>> loadFromAllStores(Object var1, boolean var2, boolean var3);

    @Deprecated
    default public <K, V> MarshallableEntry<K, V> loadFromAllStoresSync(Object key, boolean localInvocation, boolean includeStores) {
        return CompletionStages.join(this.loadFromAllStores(key, localInvocation, includeStores));
    }

    default public <K, V> CompletionStage<MarshallableEntry<K, V>> loadFromAllStores(Object key, int segment, boolean localInvocation, boolean includeStores) {
        return this.loadFromAllStores(key, localInvocation, includeStores);
    }

    @Deprecated
    default public <K, V> MarshallableEntry<K, V> loadFromAllStoresSync(Object key, int segment, boolean localInvocation, boolean includeStores) {
        return CompletionStages.join(this.loadFromAllStores(key, segment, localInvocation, includeStores));
    }

    default public CompletionStage<Integer> size() {
        return this.size(AccessMode.BOTH);
    }

    public CompletionStage<Integer> size(Predicate<? super StoreConfiguration> var1);

    public CompletionStage<Integer> size(IntSet var1);

    public void setClearOnStop(boolean var1);

    public void writeToAllNonTxStoresSync(MarshallableEntry var1, int var2, Predicate<? super StoreConfiguration> var3);

    default public CompletionStage<Void> writeToAllNonTxStores(MarshallableEntry marshalledEntry, int segment, Predicate<? super StoreConfiguration> predicate) {
        return this.writeToAllNonTxStores(marshalledEntry, segment, predicate, 0L);
    }

    public CompletionStage<Void> writeToAllNonTxStores(MarshallableEntry var1, int var2, Predicate<? super StoreConfiguration> var3, long var4);

    public CompletionStage<Void> prepareAllTxStores(Transaction var1, BatchModification var2, Predicate<? super StoreConfiguration> var3) throws PersistenceException;

    public CompletionStage<Void> commitAllTxStores(Transaction var1, Predicate<? super StoreConfiguration> var2);

    public CompletionStage<Void> rollbackAllTxStores(Transaction var1, Predicate<? super StoreConfiguration> var2);

    public CompletionStage<Void> writeBatchToAllNonTxStores(Iterable<MarshallableEntry> var1, Predicate<? super StoreConfiguration> var2, long var3);

    public CompletionStage<Void> deleteBatchFromAllNonTxStores(Iterable<Object> var1, Predicate<? super StoreConfiguration> var2, long var3);

    public boolean isAvailable();

    default public CompletionStage<Boolean> addSegments(IntSet segments) {
        return CompletableFutures.completedTrue();
    }

    default public CompletionStage<Boolean> removeSegments(IntSet segments) {
        return CompletableFutures.completedTrue();
    }

    public boolean isReadOnly();

    public static enum AccessMode implements Predicate<StoreConfiguration>
    {
        BOTH{

            @Override
            public boolean test(StoreConfiguration configuration) {
                return true;
            }
        }
        ,
        SHARED{

            @Override
            public boolean test(StoreConfiguration configuration) {
                return configuration.shared();
            }
        }
        ,
        PRIVATE{

            @Override
            public boolean test(StoreConfiguration configuration) {
                return !configuration.shared();
            }
        }
        ,
        ASYNC{

            @Override
            public boolean test(StoreConfiguration configuration) {
                return configuration.async().enabled();
            }
        }
        ,
        NOT_ASYNC{

            @Override
            public boolean test(StoreConfiguration configuration) {
                return !configuration.async().enabled();
            }
        };

    }
}

