/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.intops.primitive.d;

import io.reactivex.Flowable;
import java.util.stream.DoubleStream;
import org.infinispan.stream.impl.intops.IntermediateOperation;

public class LimitDoubleOperation
implements IntermediateOperation<Double, DoubleStream, Double, DoubleStream> {
    private final long limit;

    public LimitDoubleOperation(long limit) {
        if (limit <= 0L) {
            throw new IllegalArgumentException("Limit must be greater than 0");
        }
        this.limit = limit;
    }

    @Override
    public DoubleStream perform(DoubleStream stream) {
        return stream.limit(this.limit);
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public Flowable<Double> mapFlowable(Flowable<Double> input) {
        return input.limit(this.limit);
    }
}

