/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.jaxrs.JaxrsAttribute;
import org.jboss.as.jaxrs.JaxrsConstants;
import org.jboss.as.jaxrs.JaxrsElement;
import org.jboss.as.jaxrs.JaxrsExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JaxrsSubsystemParser_2_0
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    static final PathAddress PATH_ADDRESS = PathAddress.pathAddress((PathElement[])new PathElement[]{JaxrsExtension.SUBSYSTEM_PATH});

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{JaxrsExtension.SUBSYSTEM_PATH});
        ModelNode subsystem = Util.createAddOperation((PathAddress)address);
        list.add(subsystem);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        EnumSet<JaxrsElement> encountered = EnumSet.noneOf(JaxrsElement.class);
        block23: while (reader.hasNext() && reader.nextTag() != 2) {
            JaxrsElement element = JaxrsElement.forName(reader.getLocalName());
            switch (element) {
                case JAXRS_2_0_REQUEST_MATCHING: {
                    this.handleSimpleElement(reader, encountered, subsystem, JaxrsElement.JAXRS_2_0_REQUEST_MATCHING);
                    continue block23;
                }
                case RESTEASY_ADD_CHARSET: {
                    this.handleSimpleElement(reader, encountered, subsystem, JaxrsElement.RESTEASY_ADD_CHARSET);
                    continue block23;
                }
                case RESTEASY_BUFFER_EXCEPTION_ENTITY: {
                    this.handleSimpleElement(reader, encountered, subsystem, JaxrsElement.RESTEASY_BUFFER_EXCEPTION_ENTITY);
                    continue block23;
                }
                case RESTEASY_DISABLE_HTML_SANITIZER: {
                    this.handleSimpleElement(reader, encountered, subsystem, JaxrsElement.RESTEASY_DISABLE_HTML_SANITIZER);
                    continue block23;
                }
                case RESTEASY_DISABLE_PROVIDERS: {
                    this.handleList("class", reader, encountered, subsystem, JaxrsElement.RESTEASY_DISABLE_PROVIDERS);
                    continue block23;
                }
                case RESTEASY_DOCUMENT_EXPAND_ENTITY_REFERENCES: {
                    this.handleSimpleElement(reader, encountered, subsystem, JaxrsElement.RESTEASY_DOCUMENT_EXPAND_ENTITY_REFERENCES);
                    continue block23;
                }
                case RESTEASY_DOCUMENT_SECURE_DISABLE_DTDS: {
                    this.handleSimpleElement(reader, encountered, subsystem, JaxrsElement.RESTEASY_DOCUMENT_SECURE_DISABLE_DTDS);
                    continue block23;
                }
                case RESTEASY_DOCUMENT_SECURE_PROCESSING_FEATURE: {
                    this.handleSimpleElement(reader, encountered, subsystem, JaxrsElement.RESTEASY_DOCUMENT_SECURE_PROCESSING_FEATURE);
                    continue block23;
                }
                case RESTEASY_GZIP_MAX_INPUT: {
                    this.handleSimpleElement(reader, encountered, subsystem, JaxrsElement.RESTEASY_GZIP_MAX_INPUT);
                    continue block23;
                }
                case RESTEASY_JNDI_RESOURCES: {
                    this.handleList("jndi", reader, encountered, subsystem, JaxrsElement.RESTEASY_JNDI_RESOURCES);
                    continue block23;
                }
                case RESTEASY_LANGUAGE_MAPPINGS: {
                    this.handleMap(reader, encountered, subsystem, JaxrsElement.RESTEASY_LANGUAGE_MAPPINGS);
                    continue block23;
                }
                case RESTEASY_MEDIA_TYPE_MAPPINGS: {
                    this.handleMap(reader, encountered, subsystem, JaxrsElement.RESTEASY_MEDIA_TYPE_MAPPINGS);
                    continue block23;
                }
                case RESTEASY_MEDIA_TYPE_PARAM_MAPPING: {
                    this.handleSimpleElement(reader, encountered, subsystem, JaxrsElement.RESTEASY_MEDIA_TYPE_PARAM_MAPPING);
                    continue block23;
                }
                case RESTEASY_PREFER_JACKSON_OVER_JSONB: {
                    this.handleSimpleElement(reader, encountered, subsystem, JaxrsElement.RESTEASY_PREFER_JACKSON_OVER_JSONB);
                    continue block23;
                }
                case RESTEASY_PROVIDERS: {
                    this.handleList("class", reader, encountered, subsystem, JaxrsElement.RESTEASY_PROVIDERS);
                    continue block23;
                }
                case RESTEASY_RFC7232_PRECONDITIONS: {
                    this.handleSimpleElement(reader, encountered, subsystem, JaxrsElement.RESTEASY_RFC7232_PRECONDITIONS);
                    continue block23;
                }
                case RESTEASY_ROLE_BASED_SECURITY: {
                    this.handleSimpleElement(reader, encountered, subsystem, JaxrsElement.RESTEASY_ROLE_BASED_SECURITY);
                    continue block23;
                }
                case RESTEASY_SECURE_RANDOM_MAX_USE: {
                    this.handleSimpleElement(reader, encountered, subsystem, JaxrsElement.RESTEASY_SECURE_RANDOM_MAX_USE);
                    continue block23;
                }
                case RESTEASY_USE_BUILTIN_PROVIDERS: {
                    this.handleSimpleElement(reader, encountered, subsystem, JaxrsElement.RESTEASY_USE_BUILTIN_PROVIDERS);
                    continue block23;
                }
                case RESTEASY_USE_CONTAINER_FORM_PARAMS: {
                    this.handleSimpleElement(reader, encountered, subsystem, JaxrsElement.RESTEASY_USE_CONTAINER_FORM_PARAMS);
                    continue block23;
                }
                case RESTEASY_WIDER_REQUEST_MATCHING: {
                    this.handleSimpleElement(reader, encountered, subsystem, JaxrsElement.RESTEASY_WIDER_REQUEST_MATCHING);
                    continue block23;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement("urn:jboss:domain:jaxrs:2.0", false);
        ModelNode subsystem = context.getModelNode();
        for (AttributeDefinition attr : JaxrsAttribute.ATTRIBUTES) {
            attr.marshallAsElement(subsystem, true, (XMLStreamWriter)streamWriter);
        }
        streamWriter.writeEndElement();
    }

    protected void handleSimpleElement(XMLExtendedStreamReader reader, EnumSet<JaxrsElement> encountered, ModelNode subsystem, JaxrsElement element) throws XMLStreamException {
        if (!encountered.add(element)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        String name = element.getLocalName();
        String value = this.parseElementNoAttributes(reader);
        SimpleAttributeDefinition attribute = (SimpleAttributeDefinition)JaxrsConstants.nameToAttributeMap.get(name);
        attribute.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
    }

    protected void handleList(String tag, XMLExtendedStreamReader reader, EnumSet<JaxrsElement> encountered, ModelNode subsystem, JaxrsElement element) throws XMLStreamException {
        if (!encountered.add(element)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        String name = element.getLocalName();
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (!tag.equals(reader.getLocalName())) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            String value = this.parseElementNoAttributes(reader);
            subsystem.get(name).add(value);
        }
    }

    protected void handleMap(XMLExtendedStreamReader reader, EnumSet<JaxrsElement> encountered, ModelNode subsystem, JaxrsElement element) throws XMLStreamException {
        if (!encountered.add(element)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        String name = element.getLocalName();
        PropertiesAttributeDefinition attribute = (PropertiesAttributeDefinition)JaxrsConstants.nameToAttributeMap.get(name);
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (!"entry".equals(reader.getLocalName())) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            String[] array = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{"key"});
            if (array.length != 1) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            String value = reader.getElementText().trim();
            attribute.parseAndAddParameterElement(array[0], value, subsystem, reader);
        }
    }

    protected String parseElementNoAttributes(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        return reader.getElementText().trim();
    }
}

