/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.sso;

import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.hotrod.tx.HotRodBatcher;
import org.wildfly.clustering.marshalling.spi.MarshalledValueMarshaller;
import org.wildfly.clustering.web.cache.sso.CompositeSSOManager;
import org.wildfly.clustering.web.hotrod.sso.HotRodSSOFactory;
import org.wildfly.clustering.web.hotrod.sso.HotRodSSOManagerFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.sso.coarse.CoarseSessionsFactory;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerConfiguration;
import org.wildfly.clustering.web.sso.SSOManagerFactory;

public class HotRodSSOManagerFactory<A, D, S>
implements SSOManagerFactory<A, D, S, TransactionBatch> {
    private final HotRodSSOManagerFactoryConfiguration configuration;

    public HotRodSSOManagerFactory(HotRodSSOManagerFactoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public <C, L> SSOManager<A, D, S, L, TransactionBatch> createSSOManager(SSOManagerConfiguration<C, L> config) {
        RemoteCache cache = this.configuration.getRemoteCache();
        CoarseSessionsFactory sessionsFactory = new CoarseSessionsFactory(this.configuration.getRemoteCache());
        HotRodSSOFactory factory = new HotRodSSOFactory(this.configuration.getRemoteCache(), new MarshalledValueMarshaller(config.getMarshalledValueFactory()), config.getLocalContextFactory(), sessionsFactory);
        HotRodBatcher batcher = new HotRodBatcher(cache);
        return new CompositeSSOManager(factory, config.getIdentifierFactory(), (Batcher)batcher);
    }
}

