/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.ParserNamespaceSupport;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.identity.federation.core.parsers.saml.SAML11AssertionParser;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11ResponseType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11StatusCodeType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11StatusType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusDetailType;
import org.w3c.dom.Element;

public class SAML11ResponseParser
implements ParserNamespaceSupport {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final String RESPONSE = JBossSAMLConstants.RESPONSE.get();

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)this.RESPONSE);
        Attribute idAttr = startElement.getAttributeByName(new QName("ResponseID"));
        if (idAttr == null) {
            throw logger.parserRequiredAttribute("ResponseID");
        }
        String id = StaxParserUtil.getAttributeValue((Attribute)idAttr);
        Attribute issueInstant = startElement.getAttributeByName(new QName("IssueInstant"));
        if (issueInstant == null) {
            throw logger.parserRequiredAttribute("IssueInstant");
        }
        XMLGregorianCalendar issueInstantVal = XMLTimeUtil.parse(StaxParserUtil.getAttributeValue((Attribute)issueInstant));
        SAML11ResponseType response = new SAML11ResponseType(id, issueInstantVal);
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader)) != null) {
            String elementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (JBossSAMLConstants.SIGNATURE.get().equals(elementName)) {
                Element sig = StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader);
                response.setSignature(sig);
                continue;
            }
            if (JBossSAMLConstants.ASSERTION.get().equals(elementName)) {
                SAML11AssertionParser assertionParser = new SAML11AssertionParser();
                response.add((SAML11AssertionType)assertionParser.parse(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.STATUS.get().equals(elementName)) {
                response.setStatus(this.parseStatus(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownStartElement(elementName, startElement.getLocation());
        }
        return response;
    }

    protected SAML11StatusType parseStatus(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        String STATUS = JBossSAMLConstants.STATUS.get();
        StaxParserUtil.validate((StartElement)startElement, (String)STATUS);
        SAML11StatusType status = new SAML11StatusType();
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader)) != null) {
            EndElement endElement;
            XMLEvent xmlEvent;
            QName startElementName = startElement.getName();
            String elementTag = startElementName.getLocalPart();
            SAML11StatusCodeType statusCode = null;
            if (JBossSAMLConstants.STATUS_CODE.get().equals(elementTag)) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                if (startElement == null) break;
                Attribute valueAttr = startElement.getAttributeByName(new QName("Value"));
                if (valueAttr != null) {
                    statusCode = new SAML11StatusCodeType(new QName(StaxParserUtil.getAttributeValue((Attribute)valueAttr)));
                }
                status.setStatusCode(statusCode);
                startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
                elementTag = startElement.getName().getLocalPart();
                if (JBossSAMLConstants.STATUS_CODE.get().equals(elementTag)) {
                    SAML11StatusCodeType subStatusCodeType = null;
                    startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    Attribute subValueAttr = startElement.getAttributeByName(new QName("Value"));
                    if (subValueAttr != null) {
                        subStatusCodeType = new SAML11StatusCodeType(new QName(StaxParserUtil.getAttributeValue((Attribute)subValueAttr)));
                    }
                    statusCode.setStatusCode(subStatusCodeType);
                    EndElement endElement2 = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    StaxParserUtil.validate((EndElement)endElement2, (String)JBossSAMLConstants.STATUS_CODE.get());
                    continue;
                }
            }
            if (JBossSAMLConstants.STATUS_MESSAGE.get().equals(elementTag)) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                if (startElement == null) break;
                status.setStatusMessage(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader));
            }
            if (JBossSAMLConstants.STATUS_DETAIL.get().equals(elementTag)) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                if (startElement == null) break;
                Element domElement = StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader);
                StatusDetailType statusDetailType = new StatusDetailType();
                statusDetailType.addStatusDetail(domElement);
                status.setStatusDetail(statusDetailType);
            }
            if (!((xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) instanceof EndElement) || StaxParserUtil.matches((EndElement)(endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader)), (String)STATUS)) break;
            throw logger.parserUnknownEndElement(StaxParserUtil.getEndElementName((EndElement)endElement));
        }
        return status;
    }

    public boolean supports(QName qname) {
        return "urn:oasis:names:tc:SAML:1.0:protocol".equals(qname.getNamespaceURI()) && this.RESPONSE.equals(qname.getLocalPart());
    }
}

