/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.module.ExtensionInfo;
import org.jboss.as.server.moduleservice.ExtensionIndex;
import org.jboss.as.server.moduleservice.ExternalModuleSpecService;
import org.jboss.as.server.moduleservice.ModuleLoadService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.VFSUtils;

public final class ExtensionIndexService
implements Service<ExtensionIndex>,
ExtensionIndex {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.deployment.module.extension-index");
    public static final String MODULE_PREFIX = "deployment.extension.";
    private final File[] extensionRoots;
    private final Map<String, Set<ExtensionJar>> extensions = new HashMap<String, Set<ExtensionJar>>();

    public ExtensionIndexService(File ... roots) {
        this.extensionRoots = roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        context.getController().compareAndSetMode(ServiceController.Mode.ON_DEMAND, ServiceController.Mode.ACTIVE);
        this.extensions.clear();
        for (File root : this.extensionRoots) {
            File[] jars = root.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().endsWith(".jar") && !file.isDirectory();
                }
            });
            if (jars == null) continue;
            for (File jar : jars) {
                try {
                    JarFile jarFile = new JarFile(jar);
                    try {
                        ModuleIdentifier moduleIdentifier;
                        ExtensionJar extensionJar;
                        Attributes mainAttributes;
                        String extensionName;
                        Manifest manifest = jarFile.getManifest();
                        if (manifest == null || (extensionName = (mainAttributes = manifest.getMainAttributes()).getValue(Attributes.Name.EXTENSION_NAME)) == null) continue;
                        String implVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                        String specVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                        String implVendorId = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR_ID);
                        jarFile.close();
                        Set<ExtensionJar> extensionJarSet = this.extensions.get(extensionName);
                        if (extensionJarSet == null) {
                            extensionJarSet = new LinkedHashSet<ExtensionJar>();
                            this.extensions.put(extensionName, extensionJarSet);
                        }
                        if (extensionJarSet.contains(extensionJar = new ExtensionJar(moduleIdentifier = ExtensionIndexService.moduleIdentifier(extensionName, specVersion, implVersion, implVendorId), implVersion, implVendorId, specVersion, jar.getAbsolutePath()))) continue;
                        ExternalModuleSpecService service = new ExternalModuleSpecService(moduleIdentifier, jar);
                        ServiceName serviceName = ServiceModuleLoader.moduleSpecServiceName(moduleIdentifier);
                        ServiceBuilder sb = context.getChildTarget().addService(serviceName, (Service)service);
                        sb.requires(Services.JBOSS_DEPLOYMENT_EXTENSION_INDEX);
                        sb.setInitialMode(ServiceController.Mode.ON_DEMAND);
                        sb.install();
                        ModuleLoadService.install(context.getChildTarget(), moduleIdentifier);
                        extensionJarSet.add(extensionJar);
                    }
                    finally {
                        VFSUtils.safeClose((ZipFile)jarFile);
                    }
                }
                catch (IOException e) {
                    log.debugf("Failed to process JAR manifest for %s: %s", (Object)jar, (Object)e);
                }
            }
        }
    }

    public synchronized void stop(StopContext context) {
        this.extensions.clear();
    }

    @Override
    public synchronized void addDeployedExtension(ModuleIdentifier identifier, ExtensionInfo extensionInfo) {
        ExtensionJar extensionJar = new ExtensionJar(identifier, extensionInfo);
        Set<ExtensionJar> jars = this.extensions.get(extensionInfo.getName());
        if (jars == null) {
            jars = new HashSet<ExtensionJar>();
            this.extensions.put(extensionInfo.getName(), jars);
        }
        jars.add(extensionJar);
    }

    @Override
    public synchronized boolean removeDeployedExtension(String name, ModuleIdentifier identifier) {
        Set<ExtensionJar> jars = this.extensions.get(name);
        if (jars != null) {
            Iterator<ExtensionJar> it = jars.iterator();
            while (it.hasNext()) {
                ExtensionJar jar = it.next();
                if (!jar.moduleIdentifier.equals(identifier)) continue;
                it.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized ModuleIdentifier findExtension(String name, String minSpecVersion, String minImplVersion, String requiredVendorId) {
        Set<ExtensionJar> jars = this.extensions.get(name.trim());
        if (jars != null) {
            for (ExtensionJar extensionJar : jars) {
                block14: {
                    block13: {
                        String implVendorId = extensionJar.implVendorId;
                        if (requiredVendorId != null && !requiredVendorId.equals(implVendorId.trim())) {
                            log.debugf("Skipping extension JAR %s because vendor ID %s does not match required vendor ID %s", (Object)extensionJar.path, (Object)requiredVendorId, (Object)implVendorId);
                            continue;
                        }
                        if (minSpecVersion != null) {
                            String specVersion = extensionJar.specVersion;
                            if (specVersion == null) {
                                log.debugf("Skipping extension JAR %s because spec version is missing but %s is required", (Object)extensionJar.path, (Object)minSpecVersion);
                                continue;
                            }
                            try {
                                if (ExtensionIndexService.compareVersion(minSpecVersion.trim(), specVersion) > 0) {
                                    log.debugf("Skipping extension JAR %s because spec version %s is less than required version %s", (Object)extensionJar.path, (Object)specVersion, (Object)minSpecVersion);
                                }
                                break block13;
                            }
                            catch (NumberFormatException e) {
                                log.debugf("Skipping extension JAR %s because version compare of spec version failed", new Object[0]);
                            }
                            continue;
                        }
                    }
                    if (minImplVersion != null) {
                        String implVersion = extensionJar.implVersion;
                        if (implVersion == null) {
                            log.debugf("Skipping extension JAR %s because impl version is missing but %s is required", (Object)extensionJar.path, (Object)minImplVersion);
                            continue;
                        }
                        try {
                            if (ExtensionIndexService.compareVersion(minImplVersion.trim(), implVersion) > 0) {
                                log.debugf("Skipping extension JAR %s because impl version %s is less than required version %s", (Object)extensionJar.path, (Object)implVersion, (Object)minImplVersion);
                            }
                            break block14;
                        }
                        catch (NumberFormatException e) {
                            log.debugf("Skipping extension JAR %s because version compare of impl version failed", new Object[0]);
                        }
                        continue;
                    }
                }
                log.debugf("Matched extension JAR %s", (Object)extensionJar.path);
                return extensionJar.moduleIdentifier;
            }
        }
        return null;
    }

    public static ModuleIdentifier moduleIdentifier(String name, String minSpecVersion, String minImplVersion, String requiredVendorId) {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(MODULE_PREFIX);
        nameBuilder.append(name);
        if (minSpecVersion != null) {
            nameBuilder.append(".spec-");
            nameBuilder.append(minSpecVersion);
        }
        if (minImplVersion != null) {
            nameBuilder.append(".impl-");
            nameBuilder.append(minImplVersion);
        }
        if (requiredVendorId != null) {
            nameBuilder.append(".vendor-");
            nameBuilder.append(requiredVendorId);
        }
        return ModuleIdentifier.create((String)nameBuilder.toString());
    }

    public ExtensionIndex getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private static int compareVersion(String v1, String v2) {
        if (v1.isEmpty() && v2.isEmpty()) {
            return 0;
        }
        if (v1.isEmpty()) {
            return -1;
        }
        if (v2.isEmpty()) {
            return 1;
        }
        int s1 = 0;
        int s2 = 0;
        while (true) {
            int i2;
            int e1 = v1.indexOf(46, s1);
            int e2 = v2.indexOf(46, s2);
            String seg1 = e1 == -1 ? v1.substring(s1) : v1.substring(s1, e1);
            String seg2 = e2 == -1 ? v2.substring(s2) : v2.substring(s2, e2);
            int i1 = Integer.parseInt(seg1);
            if (i1 > (i2 = Integer.parseInt(seg2))) {
                return 1;
            }
            if (i1 < i2) {
                return -1;
            }
            if (e1 == -1 && e2 == -1) {
                return 0;
            }
            if (e1 == -1) {
                return 1;
            }
            if (e2 == -1) {
                return -1;
            }
            s1 = e1 + 1;
            s2 = e2 + 1;
        }
    }

    private static void addResourceRoot(ModuleSpec.Builder specBuilder, String name, JarFile jarFile) {
        specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((String)name, (JarFile)jarFile)));
    }

    static class ExtensionJar {
        private final String implVersion;
        private final String implVendorId;
        private final String specVersion;
        private final String path;
        private final ModuleIdentifier moduleIdentifier;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.implVendorId == null ? 0 : this.implVendorId.hashCode());
            result = 31 * result + (this.implVersion == null ? 0 : this.implVersion.hashCode());
            result = 31 * result + (this.specVersion == null ? 0 : this.specVersion.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExtensionJar other = (ExtensionJar)obj;
            if (this.implVendorId == null ? other.implVendorId != null : !this.implVendorId.equals(other.implVendorId)) {
                return false;
            }
            if (this.implVersion == null ? other.implVersion != null : !this.implVersion.equals(other.implVersion)) {
                return false;
            }
            return !(this.specVersion == null ? other.specVersion != null : !this.specVersion.equals(other.specVersion));
        }

        ExtensionJar(ModuleIdentifier moduleIdentifier, String implVersion, String implVendorId, String specVersion, String path) {
            this.implVersion = implVersion;
            this.implVendorId = implVendorId;
            this.specVersion = specVersion;
            this.path = path;
            this.moduleIdentifier = moduleIdentifier;
        }

        ExtensionJar(ModuleIdentifier moduleIdentifier, ExtensionInfo info) {
            this.implVersion = info.getImplVersion();
            this.implVendorId = info.getImplVendorId();
            this.specVersion = info.getSpecVersion();
            this.path = null;
            this.moduleIdentifier = moduleIdentifier;
        }
    }
}

