/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.persistence.remote.configuration.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.persistence.remote.configuration.SecurityConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.TrustStoreConfiguration;

public class TrustStoreConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<TrustStoreConfiguration>,
ConfigurationBuilderInfo {
    private static final Log log = LogFactory.getLog(TrustStoreConfigurationBuilder.class);

    protected TrustStoreConfigurationBuilder(SecurityConfigurationBuilder builder) {
        super(builder, TrustStoreConfiguration.attributeDefinitionSet());
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return TrustStoreConfiguration.ELEMENT_DEFINITION;
    }

    public TrustStoreConfigurationBuilder trustStoreFileName(String trustStoreFileName) {
        this.attributes.attribute(TrustStoreConfiguration.TRUSTSTORE_FILENAME).set((Object)trustStoreFileName);
        return this;
    }

    public TrustStoreConfigurationBuilder trustStoreType(String trustStoreType) {
        this.attributes.attribute(TrustStoreConfiguration.TRUSTSTORE_TYPE).set((Object)trustStoreType);
        return this;
    }

    public TrustStoreConfigurationBuilder trustStorePassword(char[] trustStorePassword) {
        this.attributes.attribute(TrustStoreConfiguration.TRUSTSTORE_PASSWORD).set((Object)new String(trustStorePassword));
        return this;
    }

    public void validate() {
    }

    public TrustStoreConfiguration create() {
        return new TrustStoreConfiguration(this.attributes.protect());
    }

    public TrustStoreConfigurationBuilder read(TrustStoreConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

