/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.AbstractTopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;

public class GetKeysInGroupCommand
extends AbstractTopologyAffectedCommand
implements VisitableCommand {
    public static final byte COMMAND_ID = 43;
    private Object groupName;
    private transient boolean isGroupOwner;

    public GetKeysInGroupCommand(long flagsBitSet, Object groupName) {
        this.groupName = groupName;
        this.setFlagsBitSet(flagsBitSet);
    }

    public GetKeysInGroupCommand() {
    }

    @Override
    public byte getCommandId() {
        return 43;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.groupName);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.groupName = input.readObject();
        this.setFlagsBitSet(input.readLong());
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetKeysInGroupCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    public Object getGroupName() {
        return this.groupName;
    }

    public String toString() {
        return "GetKeysInGroupCommand{groupName='" + this.groupName + '\'' + ", flags=" + this.printFlags() + '}';
    }

    public boolean isGroupOwner() {
        return this.isGroupOwner;
    }

    public void setGroupOwner(boolean isGroupOwner) {
        this.isGroupOwner = isGroupOwner;
    }
}

