/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoader;
import org.jboss.logging.Logger;

public class ReloadableProperties {
    private static final Logger logger = Logger.getLogger(ReloadableProperties.class);
    private Properties props = new Properties();
    private Map<String, String> invertedProps;
    private Map<String, Set<String>> invertedValueProps;
    private Map<String, Pattern> regexpProps;
    private long reloadTime = -1L;
    private final PropertiesLoader.FileNameKey key;

    public ReloadableProperties(PropertiesLoader.FileNameKey key) {
        this.key = key;
    }

    public synchronized Properties getProps() {
        return this.props;
    }

    public synchronized ReloadableProperties obtained() {
        if (this.reloadTime < 0L || this.key.isReload() && this.hasModificationAfter(this.reloadTime)) {
            block4: {
                this.props = new Properties();
                try {
                    this.load(this.key.file(), this.props);
                    this.invertedProps = null;
                    this.invertedValueProps = null;
                    this.regexpProps = null;
                    if (this.key.isDebug()) {
                        logger.debug((Object)("Load of: " + this.key));
                    }
                }
                catch (IOException e) {
                    ActiveMQServerLogger.LOGGER.failedToLoadProperty(e, this.key.toString(), e.getLocalizedMessage());
                    if (!this.key.isDebug()) break block4;
                    logger.debug((Object)("Load of: " + this.key + ", failure exception" + e));
                }
            }
            this.reloadTime = System.currentTimeMillis();
        }
        return this;
    }

    public synchronized Map<String, String> invertedPropertiesMap() {
        if (this.invertedProps == null) {
            this.invertedProps = new HashMap<String, String>(this.props.size());
            for (Map.Entry<Object, Object> val : this.props.entrySet()) {
                String str = (String)val.getValue();
                if (this.looksLikeRegexp(str)) continue;
                this.invertedProps.put(str, (String)val.getKey());
            }
        }
        return this.invertedProps;
    }

    public synchronized Map<String, Set<String>> invertedPropertiesValuesMap() {
        if (this.invertedValueProps == null) {
            this.invertedValueProps = new HashMap<String, Set<String>>(this.props.size());
            for (Map.Entry<Object, Object> val : this.props.entrySet()) {
                String[] userList;
                for (String user : userList = ((String)val.getValue()).split(",")) {
                    Set<String> set = this.invertedValueProps.get(user);
                    if (set == null) {
                        set = new HashSet<String>();
                        this.invertedValueProps.put(user, set);
                    }
                    set.add((String)val.getKey());
                }
            }
        }
        return this.invertedValueProps;
    }

    public synchronized Map<String, Pattern> regexpPropertiesMap() {
        if (this.regexpProps == null) {
            this.regexpProps = new HashMap<String, Pattern>(this.props.size());
            for (Map.Entry<Object, Object> val : this.props.entrySet()) {
                String str = (String)val.getValue();
                if (!this.looksLikeRegexp(str)) continue;
                try {
                    Pattern p = Pattern.compile(str.substring(1, str.length() - 1));
                    this.regexpProps.put((String)val.getKey(), p);
                }
                catch (PatternSyntaxException e) {
                    ActiveMQServerLogger.LOGGER.warn("Ignoring invalid regexp: " + str);
                }
            }
        }
        return this.regexpProps;
    }

    private void load(File source, Properties props) throws IOException {
        try (FileInputStream in = new FileInputStream(source);){
            props.load(in);
        }
    }

    private boolean hasModificationAfter(long reloadTime) {
        return this.key.file.lastModified() > reloadTime;
    }

    private boolean looksLikeRegexp(String str) {
        int len = str.length();
        return len > 2 && str.charAt(0) == '/' && str.charAt(len - 1) == '/';
    }
}

