/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.parsing.Element;

public final class EncodingConfiguration
implements Matchable<EncodingConfiguration>,
ConfigurationInfo {
    private ContentTypeConfiguration keyDataType;
    private ContentTypeConfiguration valueDataType;
    private final List<ConfigurationInfo> contentTypeConfigurations;
    public static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.ENCODING.getLocalName());

    public EncodingConfiguration(ContentTypeConfiguration keyDataType, ContentTypeConfiguration valueDataType) {
        this.keyDataType = keyDataType;
        this.valueDataType = valueDataType;
        this.contentTypeConfigurations = Arrays.asList(keyDataType, valueDataType);
    }

    public ContentTypeConfiguration keyDataType() {
        return this.keyDataType;
    }

    public ContentTypeConfiguration valueDataType() {
        return this.valueDataType;
    }

    public String toString() {
        return "DataTypeConfiguration [keyDataType=" + this.keyDataType + ", valueDataType=" + this.valueDataType + "]";
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncodingConfiguration that = (EncodingConfiguration)o;
        return Objects.equals(this.keyDataType, that.keyDataType) && Objects.equals(this.valueDataType, that.valueDataType);
    }

    public int hashCode() {
        return Objects.hash(this.keyDataType, this.valueDataType);
    }

    public List<ConfigurationInfo> subElements() {
        return this.contentTypeConfigurations;
    }
}

