/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.lang.invoke.MethodHandles;
import java.util.PrimitiveIterator;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.notifications.cachelistener.BaseQueueingSegmentListener;
import org.infinispan.notifications.cachelistener.EventWrapper;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.impl.ListenerInvocation;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class DistributedQueueingSegmentListener<K, V>
extends BaseQueueingSegmentListener<K, V, CacheEntryEvent<K, V>> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final AtomicReferenceArray<Queue<KeyValuePair<CacheEntryEvent<K, V>, ListenerInvocation<Event<K, V>>>>> queues;
    private final ToIntFunction<Object> intFunction;
    protected final InternalEntryFactory entryFactory;
    private PrimitiveIterator.OfInt justCompletedSegments = null;

    public DistributedQueueingSegmentListener(InternalEntryFactory entryFactory, int numSegments, ToIntFunction<Object> intFunction) {
        this.entryFactory = entryFactory;
        this.intFunction = intFunction;
        this.queues = new AtomicReferenceArray(numSegments);
        for (int i = 0; i < this.queues.length(); ++i) {
            ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
            this.queues.set(i, queue);
        }
    }

    @Override
    public boolean handleEvent(EventWrapper<K, V, CacheEntryEvent<K, V>> wrapped, ListenerInvocation<Event<K, V>> invocation) {
        K key = wrapped.getKey();
        boolean enqueued = !this.completed.get();
        CacheEntryEvent<K, V> event = wrapped.getEvent();
        InternalCacheEntry<K, V> cacheEntry = this.entryFactory.create(event.getKey(), event.getValue(), event.getMetadata());
        if (enqueued && !this.addEvent(key, cacheEntry.getValue() != null ? cacheEntry : REMOVED)) {
            int segment = this.intFunction.applyAsInt(key);
            Queue<KeyValuePair<CacheEntryEvent<K, V>, ListenerInvocation<Event<K, V>>>> queue = this.queues.get(segment);
            if (queue != null) {
                KeyValuePair<CacheEntryEvent<K, V>, ListenerInvocation<Event<K, V>>> eventPair = new KeyValuePair<CacheEntryEvent<K, V>, ListenerInvocation<Event<K, V>>>(event, invocation);
                queue.add(eventPair);
                if (this.queues.get(segment) == null && queue.remove(eventPair)) {
                    enqueued = false;
                }
            } else {
                enqueued = false;
            }
        }
        return enqueued;
    }

    @Override
    public CompletionStage<Void> transferComplete() {
        AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
        for (int i = 0; i < this.queues.length(); ++i) {
            CompletionStage<Void> segmentStage;
            if (this.queues.get(i) == null || (segmentStage = this.completeSegment(i)) == null) continue;
            aggregateCompletionStage.dependsOn(segmentStage);
        }
        this.completed.set(true);
        this.notifiedKeys.clear();
        return aggregateCompletionStage.freeze();
    }

    @Override
    public CompletionStage<Void> notifiedKey(K key) {
        PrimitiveIterator.OfInt iter = this.justCompletedSegments;
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        if (iter != null) {
            while (iter.hasNext()) {
                CompletionStage<Void> segmentStage = this.completeSegment(iter.nextInt());
                if (segmentStage == null) continue;
                if (aggregateCompletionStage == null) {
                    aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
                }
                aggregateCompletionStage.dependsOn(segmentStage);
            }
        }
        this.justCompletedSegments = null;
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    private CompletionStage<Void> completeSegment(int segment) {
        Queue queue = this.queues.getAndSet(segment, null);
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        if (queue != null) {
            if (this.trace) {
                log.tracef("Completed segment %s", segment);
            }
            if (!queue.isEmpty()) {
                aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
                for (KeyValuePair event : queue) {
                    aggregateCompletionStage.dependsOn(((ListenerInvocation)event.getValue()).invoke((Event)event.getKey()));
                }
            }
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : null;
    }

    @Override
    public void accept(Supplier<PrimitiveIterator.OfInt> segments) {
        this.justCompletedSegments = segments.get();
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

