/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.manager;

import io.reactivex.Flowable;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.support.DelegatingPersistenceManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

public class PassivationPersistenceManager
extends DelegatingPersistenceManager {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    private final ConcurrentMap<Object, MarshallableEntry> map = new ConcurrentHashMap<Object, MarshallableEntry>();

    public PassivationPersistenceManager(PersistenceManager persistenceManager) {
        super(persistenceManager);
    }

    public CompletionStage<Void> passivate(MarshallableEntry marshallableEntry, int segment) {
        Object key = marshallableEntry.getKey();
        if (trace) {
            log.tracef("Storing entry temporarily during passivation for key %s", key);
        }
        this.map.put(key, marshallableEntry);
        return this.writeToAllNonTxStores(marshallableEntry, segment, PersistenceManager.AccessMode.PRIVATE).whenComplete((ignore, ignoreT) -> {
            this.map.remove(key);
            if (trace) {
                log.tracef("Removed temporary entry during passivation for key %s", key);
            }
        });
    }

    @Override
    public <K, V> CompletionStage<MarshallableEntry<K, V>> loadFromAllStores(Object key, int segment, boolean localInvocation, boolean includeStores) {
        MarshallableEntry entry = (MarshallableEntry)this.map.get(key);
        if (entry != null) {
            if (trace) {
                log.tracef("Retrieved entry for key %s from temporary passivation map", key);
            }
            return CompletableFuture.completedFuture(entry);
        }
        return super.loadFromAllStores(key, segment, localInvocation, includeStores);
    }

    @Override
    public <K, V> CompletionStage<MarshallableEntry<K, V>> loadFromAllStores(Object key, boolean localInvocation, boolean includeStores) {
        MarshallableEntry entry = (MarshallableEntry)this.map.get(key);
        if (entry != null) {
            if (trace) {
                log.tracef("Retrieved entry for key %s from temporary passivation map", key);
            }
            return CompletableFuture.completedFuture(entry);
        }
        return super.loadFromAllStores(key, localInvocation, includeStores);
    }

    @Override
    public <K> Publisher<K> publishKeys(Predicate<? super K> filter, Predicate<? super StoreConfiguration> predicate) {
        if (this.map.isEmpty()) {
            return super.publishKeys(filter, predicate);
        }
        HashSet keys = new HashSet(this.map.keySet());
        Predicate<Object> filterToUse = key -> !keys.contains(key);
        Flowable mapFlowable = Flowable.fromIterable(keys);
        if (filter != null) {
            filterToUse = filterToUse.and(filter);
            mapFlowable = mapFlowable.filter(filter::test);
        }
        return Flowable.concat((Publisher)mapFlowable, super.publishKeys(filterToUse, predicate));
    }

    @Override
    public <K> Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter, Predicate<? super StoreConfiguration> predicate) {
        if (this.map.isEmpty()) {
            return super.publishKeys(segments, filter, predicate);
        }
        HashSet keys = new HashSet(this.map.keySet());
        Predicate<Object> filterToUse = key -> !keys.contains(key);
        Flowable mapFlowable = Flowable.fromIterable(keys);
        if (filter != null) {
            filterToUse = filterToUse.and(filter);
            mapFlowable = mapFlowable.filter(filter::test);
        }
        return Flowable.concat((Publisher)mapFlowable, super.publishKeys(segments, filterToUse, predicate));
    }

    @Override
    public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(boolean fetchValue, boolean fetchMetadata) {
        if (this.map.isEmpty()) {
            return super.publishEntries(fetchValue, fetchMetadata);
        }
        HashMap<Object, MarshallableEntry> entries = new HashMap<Object, MarshallableEntry>(this.map);
        Predicate<Object> filterToUse = key -> !entries.containsKey(key);
        return Flowable.concat((Publisher)Flowable.fromIterable(entries.values()), super.publishEntries(filterToUse, fetchValue, fetchMetadata, PersistenceManager.AccessMode.BOTH));
    }

    @Override
    public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata, Predicate<? super StoreConfiguration> predicate) {
        if (this.map.isEmpty()) {
            return super.publishEntries(filter, fetchValue, fetchMetadata, predicate);
        }
        HashMap<Object, MarshallableEntry> entries = new HashMap<Object, MarshallableEntry>(this.map);
        Predicate<Object> filterToUse = key -> !entries.containsKey(key);
        Flowable mapFlowable = Flowable.fromIterable(entries.values());
        if (filter != null) {
            filterToUse = filterToUse.and(filter);
            mapFlowable = mapFlowable.filter(entry -> filter.test((Object)entry.getKey()));
        }
        return Flowable.concat((Publisher)mapFlowable, super.publishEntries(filterToUse, fetchValue, fetchMetadata, predicate));
    }

    @Override
    public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata, Predicate<? super StoreConfiguration> predicate) {
        if (this.map.isEmpty()) {
            return super.publishEntries(segments, filter, fetchValue, fetchMetadata, predicate);
        }
        HashMap<Object, MarshallableEntry> entries = new HashMap<Object, MarshallableEntry>(this.map);
        Predicate<Object> filterToUse = key -> !entries.containsKey(key);
        Flowable mapFlowable = Flowable.fromIterable(entries.values());
        if (filter != null) {
            filterToUse = filterToUse.and(filter);
            mapFlowable = mapFlowable.filter(entry -> filter.test((Object)entry.getKey()));
        }
        return Flowable.concat((Publisher)mapFlowable, super.publishEntries(segments, filterToUse, fetchValue, fetchMetadata, predicate));
    }

    @Override
    public CompletionStage<Integer> size(Predicate<? super StoreConfiguration> predicate) {
        if (this.map.isEmpty()) {
            return super.size(predicate);
        }
        return CompletableFuture.completedFuture(-1);
    }

    public int pendingPassivations() {
        return this.map.size();
    }
}

