/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.rest.bridge.inbound;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.transaction.Transactional;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.jboss.logging.Logger;
import org.jboss.narayana.rest.bridge.inbound.InboundBridge;
import org.jboss.narayana.rest.bridge.inbound.InboundBridgeManager;
import org.jboss.resteasy.core.ResourceMethodInvoker;

@Provider
public final class InboundBridgeFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger LOG = Logger.getLogger(InboundBridgeFilter.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeFilter.filter(" + requestContext + ")"));
        }
        if (this.isBridgeRequired(requestContext)) {
            String enlistmentUrl = this.getEnlistmentUrl(requestContext);
            this.startBridge(enlistmentUrl);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeFilter.filter(" + requestContext + ", " + responseContext + ")"));
        }
        if (this.isBridgeRequired(requestContext)) {
            String enlistmentUrl = this.getEnlistmentUrl(requestContext);
            this.stopBridge(enlistmentUrl);
        }
    }

    private void startBridge(String enlistmentUrl) {
        if (enlistmentUrl != null) {
            InboundBridge inboundBridge = InboundBridgeManager.getInstance().createInboundBridge(enlistmentUrl);
            inboundBridge.start();
        }
    }

    private void stopBridge(String enlistmentUrl) {
        if (enlistmentUrl != null) {
            InboundBridge inboundBridge = InboundBridgeManager.getInstance().createInboundBridge(enlistmentUrl);
            inboundBridge.stop();
        }
    }

    private String getEnlistmentUrl(ContainerRequestContext requestContext) {
        Map<String, String> links = this.getLinksFromHeaders((MultivaluedMap<String, String>)requestContext.getHeaders());
        String enlistmentUrl = this.getEnlistmentUrlFromLinks(links);
        return enlistmentUrl;
    }

    private String getEnlistmentUrlFromLinks(Map<String, String> links) {
        String enlistmentUrl = null;
        if (links.get("durable-participant") != null) {
            enlistmentUrl = links.get("durable-participant");
        }
        return enlistmentUrl;
    }

    private Map<String, String> getLinksFromHeaders(MultivaluedMap<String, String> headers) {
        Collection<String> linkHeaders = this.extractLinkHeaders(headers);
        HashMap<String, String> links = new HashMap<String, String>();
        for (String linkString : linkHeaders) {
            Link link = Link.valueOf((String)linkString);
            links.put(link.getRel(), link.getUri().toASCIIString());
        }
        return links;
    }

    private Collection<String> extractLinkHeaders(MultivaluedMap<String, String> headers) {
        ArrayList linkHeaders = (ArrayList)headers.get((Object)"Link");
        if (linkHeaders == null) {
            linkHeaders = (Collection)headers.get((Object)"link");
        }
        if (linkHeaders == null) {
            linkHeaders = new ArrayList();
        }
        return linkHeaders;
    }

    private boolean isBridgeRequired(ContainerRequestContext requestContext) {
        ResourceMethodInvoker methodInvoker = (ResourceMethodInvoker)requestContext.getProperty("org.jboss.resteasy.core.ResourceMethodInvoker");
        if (methodInvoker == null) {
            return false;
        }
        Method method = methodInvoker.getMethod();
        return method.isAnnotationPresent(Transactional.class) || method.getDeclaringClass().isAnnotationPresent(Transactional.class) || method.getDeclaringClass().isAnnotationPresent(Stateless.class) || method.getDeclaringClass().isAnnotationPresent(Stateful.class);
    }
}

