/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.Properties;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfiguration;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;

public class RemoteCacheConfigurationBuilder
implements Builder<RemoteCacheConfiguration> {
    private final ConfigurationBuilder builder;
    private final AttributeSet attributes;

    public RemoteCacheConfigurationBuilder(ConfigurationBuilder builder, String name) {
        this.builder = builder;
        this.attributes = RemoteCacheConfiguration.attributeDefinitionSet();
        this.attributes.attribute(RemoteCacheConfiguration.NAME).set((Object)name);
    }

    public RemoteCacheConfigurationBuilder forceReturnValues(boolean forceReturnValues) {
        this.attributes.attribute(RemoteCacheConfiguration.FORCE_RETURN_VALUES).set((Object)forceReturnValues);
        return this;
    }

    public RemoteCacheConfigurationBuilder nearCacheMode(NearCacheMode mode) {
        this.attributes.attribute(RemoteCacheConfiguration.NEAR_CACHE_MODE).set((Object)mode);
        return this;
    }

    public RemoteCacheConfigurationBuilder nearCacheMaxEntries(int maxEntries) {
        this.attributes.attribute(RemoteCacheConfiguration.NEAR_CACHE_MAX_ENTRIES).set((Object)maxEntries);
        return this;
    }

    public RemoteCacheConfigurationBuilder configuration(String configuration) {
        this.attributes.attribute(RemoteCacheConfiguration.CONFIGURATION).set((Object)configuration);
        return this;
    }

    public RemoteCacheConfigurationBuilder templateName(String templateName) {
        this.attributes.attribute(RemoteCacheConfiguration.TEMPLATE_NAME).set((Object)templateName);
        return this;
    }

    public RemoteCacheConfigurationBuilder templateName(DefaultTemplate template) {
        this.attributes.attribute(RemoteCacheConfiguration.TEMPLATE_NAME).set((Object)template.getTemplateName());
        return this;
    }

    public RemoteCacheConfigurationBuilder transactionMode(TransactionMode mode) {
        this.attributes.attribute(RemoteCacheConfiguration.TRANSACTION_MODE).set((Object)mode);
        return this;
    }

    public void validate() {
        if (this.attributes.attribute(RemoteCacheConfiguration.CONFIGURATION).isModified() && this.attributes.attribute(RemoteCacheConfiguration.TEMPLATE_NAME).isModified()) {
            throw Log.HOTROD.remoteCacheTemplateNameXorConfiguration((String)this.attributes.attribute(RemoteCacheConfiguration.NAME).get());
        }
    }

    public RemoteCacheConfiguration create() {
        return new RemoteCacheConfiguration(this.attributes.protect());
    }

    public Builder<?> read(RemoteCacheConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public ConfigurationBuilder withProperties(Properties properties) {
        String prefix;
        TypedProperties typed = TypedProperties.toTypedProperties((Properties)properties);
        if (typed.containsKey((Object)((prefix = "infinispan.client.hotrod.cache." + (String)this.attributes.attribute(RemoteCacheConfiguration.NAME).get()) + ".configuration"))) {
            this.configuration(typed.getProperty(prefix + ".configuration"));
        }
        if (typed.containsKey((Object)(prefix + ".force_return_values"))) {
            this.forceReturnValues(typed.getBooleanProperty(prefix + ".force_return_values", ((Boolean)RemoteCacheConfiguration.FORCE_RETURN_VALUES.getDefaultValue()).booleanValue()));
        }
        if (typed.containsKey((Object)(prefix + ".near_cache.max_entries"))) {
            this.nearCacheMaxEntries(typed.getIntProperty(prefix + ".near_cache.max_entries", ((Integer)RemoteCacheConfiguration.NEAR_CACHE_MAX_ENTRIES.getDefaultValue()).intValue()));
        }
        if (typed.containsKey((Object)(prefix + ".near_cache.mode"))) {
            this.nearCacheMode(NearCacheMode.valueOf(typed.getProperty(prefix + ".near_cache.mode")));
        }
        if (typed.containsKey((Object)(prefix + ".template_name"))) {
            this.templateName(typed.getProperty(prefix + ".template_name"));
        }
        if (typed.containsKey((Object)(prefix + ".transaction_mode"))) {
            this.transactionMode(TransactionMode.valueOf(typed.getProperty(prefix + ".transaction_mode")));
        }
        return this.builder;
    }
}

