/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg.spi;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ParameterAnnotationsReader {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());

    private ParameterAnnotationsReader() {
    }

    public static Map<String, String> toNewMutableMap(Parameter[] parameters) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (parameters != null) {
            for (Parameter param : parameters) {
                String previous = map.put(param.name(), param.value());
                if (previous == null) continue;
                throw log.conflictingParameterDefined(param.name(), param.value(), previous);
            }
        }
        return map;
    }
}

