/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import javax.jms.Connection;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.JMSSecurityRuntimeException;
import javax.jms.QueueConnection;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.GenericJmsContext;
import org.jboss.resource.adapter.jms.JmsConnectionFactory;
import org.jboss.resource.adapter.jms.JmsConnectionManager;
import org.jboss.resource.adapter.jms.JmsSession;
import org.jboss.resource.adapter.jms.JmsSessionFactoryImpl;
import org.jboss.resource.adapter.jms.util.TransactionUtils;

public class JmsConnectionFactoryImpl
implements JmsConnectionFactory,
Referenceable {
    private static final long serialVersionUID = -5135366013101194277L;
    private static final Logger log = Logger.getLogger(JmsConnectionFactoryImpl.class);
    private ManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Reference reference;

    public JmsConnectionFactoryImpl(ManagedConnectionFactory mcf, ConnectionManager cm) {
        this.mcf = mcf;
        boolean trace = log.isTraceEnabled();
        if (cm == null) {
            this.cm = new JmsConnectionManager();
            if (trace) {
                log.trace((Object)"Created new connection manager");
            }
        } else {
            this.cm = cm;
        }
        if (trace) {
            log.trace((Object)("Using ManagedConnectionFactory=" + mcf + ", ConnectionManager=" + cm));
        }
    }

    public void setReference(Reference reference) {
        this.reference = reference;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Using Reference=" + reference));
        }
    }

    public Reference getReference() {
        return this.reference;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        JmsSessionFactoryImpl qc = new JmsSessionFactoryImpl(this.mcf, this.cm, 1);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created queue connection: " + qc));
        }
        return qc;
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        JmsSessionFactoryImpl s = new JmsSessionFactoryImpl(this.mcf, this.cm, 1);
        s.setUserName(userName);
        s.setPassword(password);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created queue connection: " + s));
        }
        this.checkUserCredentials(s);
        return s;
    }

    private void checkUserCredentials(JmsSessionFactoryImpl sessionFactory) throws JMSException {
        try (Session session = null;){
            session = sessionFactory.createSession();
        }
    }

    private static JMSException findRootJMSException(JMSException jmse) {
        Throwable rootCause;
        if (jmse.getLinkedException() != null && (rootCause = JmsConnectionFactoryImpl.getRootCause(jmse.getLinkedException())) instanceof JMSException) {
            return (JMSException)rootCause;
        }
        return jmse;
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable cause;
        Throwable result = t;
        while (null != (cause = result.getCause()) && result != cause) {
            result = cause;
        }
        return result;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        JmsSessionFactoryImpl tc = new JmsSessionFactoryImpl(this.mcf, this.cm, 2);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created topic connection: " + tc));
        }
        return tc;
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        JmsSessionFactoryImpl s = new JmsSessionFactoryImpl(this.mcf, this.cm, 2);
        s.setUserName(userName);
        s.setPassword(password);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created topic connection: " + s));
        }
        this.checkUserCredentials(s);
        return s;
    }

    public Connection createConnection() throws JMSException {
        JmsSessionFactoryImpl c = new JmsSessionFactoryImpl(this.mcf, this.cm, 0);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created connection: " + c));
        }
        return c;
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        JmsSessionFactoryImpl s = new JmsSessionFactoryImpl(this.mcf, this.cm, 0);
        s.setUserName(userName);
        s.setPassword(password);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created connection: " + s));
        }
        this.checkUserCredentials(s);
        return s;
    }

    public JMSContext createContext() {
        return this.createContext(null, null);
    }

    public JMSContext createContext(String userName, String password) {
        return this.createContext(userName, password, TransactionUtils.isInTransaction() ? 0 : 1);
    }

    public JMSContext createContext(int sessionMode) {
        return this.createContext(null, null, sessionMode);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        JmsSessionFactoryImpl s = new JmsSessionFactoryImpl(this.mcf, this.cm, 3);
        s.setUserName(userName);
        s.setPassword(password);
        int effectiveSessionMode = sessionMode;
        if (TransactionUtils.isInTransaction()) {
            effectiveSessionMode = 0;
        }
        try {
            JmsSession session = s.allocateConnection(effectiveSessionMode == 0, effectiveSessionMode, 3);
            return new GenericJmsContext(s, session);
        }
        catch (JMSException e) {
            try {
                s.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            JMSException jmse = JmsConnectionFactoryImpl.findRootJMSException(e);
            if (jmse instanceof JMSSecurityException) {
                JMSSecurityRuntimeException rte = new JMSSecurityRuntimeException(jmse.getMessage(), jmse.getErrorCode(), (Throwable)jmse);
                throw rte;
            }
            JMSRuntimeException rte = new JMSRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
            throw rte;
        }
    }
}

