/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.cursor.LivePageCache;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.utils.collections.ConcurrentAppendOnlyChunkedList;
import org.jboss.logging.Logger;

public final class LivePageCacheImpl
implements LivePageCache {
    private static final Logger logger = Logger.getLogger(LivePageCacheImpl.class);
    private static final int CHUNK_SIZE = 32;
    private final ConcurrentAppendOnlyChunkedList<PagedMessage> messages;
    private final long pageId;
    private volatile boolean isLive = true;

    public LivePageCacheImpl(long pageId) {
        this.pageId = pageId;
        this.messages = new ConcurrentAppendOnlyChunkedList(32);
    }

    @Override
    public long getPageId() {
        return this.pageId;
    }

    @Override
    public int getNumberOfMessages() {
        return this.messages.size();
    }

    @Override
    public void setMessages(PagedMessage[] messages) {
        for (PagedMessage message : messages) {
            this.addLiveMessage(message);
        }
    }

    @Override
    public PagedMessage getMessage(PagePosition pagePosition) {
        return (PagedMessage)this.messages.get(pagePosition.getMessageNr());
    }

    @Override
    public boolean isLive() {
        return this.isLive;
    }

    @Override
    public void addLiveMessage(PagedMessage message) {
        if (message.getMessage().isLargeMessage()) {
            ((LargeServerMessage)message.getMessage()).incrementDelayDeletionCount();
        }
        this.messages.add((Object)message);
    }

    @Override
    public void close() {
        logger.tracef("Closing %s", (Object)this);
        this.isLive = false;
    }

    @Override
    public PagedMessage[] getMessages() {
        return (PagedMessage[])this.messages.toArray(PagedMessage[]::new);
    }

    public String toString() {
        return "LivePacheCacheImpl::page=" + this.pageId + " number of messages=" + this.getNumberOfMessages() + " isLive = " + this.isLive;
    }
}

