/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.simple;

import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.Processor;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.java2ws.util.JavaFirstUtil;
import org.apache.cxf.tools.java2wsdl.processor.internal.AntGenerator;
import org.apache.cxf.tools.java2wsdl.processor.internal.simple.generator.SimpleClientGenerator;
import org.apache.cxf.tools.java2wsdl.processor.internal.simple.generator.SimpleImplGenerator;
import org.apache.cxf.tools.java2wsdl.processor.internal.simple.generator.SimpleSEIGenerator;
import org.apache.cxf.tools.java2wsdl.processor.internal.simple.generator.SimpleServerGenerator;
import org.apache.cxf.tools.wsdlto.core.AbstractGenerator;

public class SimpleFrontEndProcessor
implements Processor {
    private ToolContext context;
    private List<AbstractGenerator> generators = new ArrayList<AbstractGenerator>();

    public void process() throws ToolException {
        List services = (List)this.context.get("serviceList");
        ServiceInfo serviceInfo = (ServiceInfo)services.get(0);
        JavaInterface jinf = JavaFirstUtil.serviceInfo2JavaInf(serviceInfo);
        JavaModel jm = new JavaModel();
        jm.addInterface("inf", jinf);
        jinf.setJavaModel(jm);
        this.context.put(JavaModel.class, (Object)jm);
        this.generators.add(new SimpleSEIGenerator());
        this.generators.add(new SimpleImplGenerator());
        this.generators.add(new SimpleServerGenerator());
        this.generators.add(new SimpleClientGenerator());
        this.generators.add(new AntGenerator());
        for (AbstractGenerator generator : this.generators) {
            generator.generate(this.context);
        }
    }

    public void setEnvironment(ToolContext env) {
        this.context = env;
    }
}

