/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.accesscontrol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.accesscontrol.BaseOperationAccessRequirement;
import org.jboss.as.cli.accesscontrol.CLIAccessControl;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.controller.client.ModelControllerClient;

public class PerNodeOperationAccess
extends BaseOperationAccessRequirement {
    private static final Boolean[] EMPTY_BARR = new Boolean[0];
    private final String nodeType;
    private List<String> nodeNames = Collections.emptyList();
    private Boolean[] stateOn = null;
    private List<String> allowedOn;

    PerNodeOperationAccess(String nodeType, String operation) {
        super(operation);
        if (nodeType == null) {
            throw new IllegalArgumentException(nodeType);
        }
        this.nodeType = nodeType;
    }

    public PerNodeOperationAccess(CommandContext ctx, String nodeType, String address, String operation) {
        this(nodeType, address, operation);
        ctx.addEventListener(this);
    }

    PerNodeOperationAccess(String nodeType, String address, String operation) {
        super(address, operation);
        if (nodeType == null) {
            throw new IllegalArgumentException(nodeType);
        }
        this.nodeType = nodeType;
    }

    PerNodeOperationAccess(String nodeType, OperationRequestAddress address, String operation) {
        super(address, operation);
        if (nodeType == null) {
            throw new IllegalArgumentException(nodeType);
        }
        this.nodeType = nodeType;
    }

    @Override
    public void resetState() {
        this.nodeNames = null;
        this.stateOn = null;
        this.allowedOn = null;
    }

    public List<String> getAllowedOn(CommandContext ctx) {
        if (this.allowedOn == null) {
            if (ctx.getConfig().isAccessControl()) {
                if (this.stateOn == null) {
                    this.initList(ctx.getModelControllerClient());
                }
                this.completeAllowedOn(ctx.getModelControllerClient());
            } else {
                this.allowedOn = Util.getNodeNames(ctx.getModelControllerClient(), null, this.nodeType);
            }
        }
        return this.allowedOn;
    }

    @Override
    protected boolean checkAccess(CommandContext ctx) {
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            return false;
        }
        if (!ctx.isDomainMode()) {
            return false;
        }
        return this.initList(client);
    }

    @Override
    public String toString() {
        if (this.toString == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.nodeType).append("=*").append(super.toString());
            this.toString = buf.toString();
        }
        return this.toString;
    }

    protected boolean initList(ModelControllerClient client) {
        this.nodeNames = Util.getNodeNames(client, null, this.nodeType);
        if (this.nodeNames.isEmpty()) {
            this.allowedOn = this.nodeNames;
            this.stateOn = EMPTY_BARR;
            return false;
        }
        this.stateOn = new Boolean[this.nodeNames.size()];
        String[] parent = new String[2];
        parent[0] = this.nodeType;
        for (int i = 0; i < this.nodeNames.size(); ++i) {
            parent[1] = this.nodeNames.get(i);
            if (CLIAccessControl.isExecute(client, parent, this.address, this.operation)) {
                this.stateOn[i] = true;
                return true;
            }
            this.stateOn[i] = false;
        }
        return false;
    }

    protected void completeAllowedOn(ModelControllerClient client) {
        if (this.nodeNames.isEmpty()) {
            this.allowedOn = this.nodeNames;
            return;
        }
        this.allowedOn = new ArrayList<String>(this.stateOn.length);
        String[] parent = new String[2];
        parent[0] = this.nodeType;
        for (int i = 0; i < this.stateOn.length; ++i) {
            Boolean state = this.stateOn[i];
            if (state == null) {
                parent[1] = this.nodeNames.get(i);
                this.stateOn[i] = state = Boolean.valueOf(CLIAccessControl.isExecute(client, parent, this.address, this.operation));
            }
            if (!state.booleanValue()) continue;
            this.allowedOn.add(this.nodeNames.get(i));
        }
    }
}

