/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.config.smallrye;

import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.microprofile.config.smallrye._private.MicroProfileConfigLogger;
import org.wildfly.extension.microprofile.config.smallrye.deployment.DependencyProcessor;
import org.wildfly.extension.microprofile.config.smallrye.deployment.SubsystemDeploymentProcessor;

class MicroProfileConfigSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    final Iterable<ConfigSourceProvider> providers;
    final Iterable<ConfigSource> sources;

    MicroProfileConfigSubsystemAdd(final Iterable<ConfigSourceProvider> providers, final Iterable<ConfigSource> sources) {
        this.providers = providers;
        this.sources = sources;
        ConfigProviderResolver.setInstance((ConfigProviderResolver)new SmallRyeConfigProviderResolver(){

            public SmallRyeConfigBuilder getBuilder() {
                return new SmallRyeConfigBuilder(){

                    public SmallRyeConfigBuilder forClassLoader(ClassLoader classLoader) {
                        SmallRyeConfigBuilder builder = super.forClassLoader(classLoader);
                        for (ConfigSourceProvider provider : providers) {
                            for (ConfigSource source : provider.getConfigSources(classLoader)) {
                                builder.withSources(new ConfigSource[]{source});
                            }
                        }
                        for (ConfigSource source : sources) {
                            builder.withSources(new ConfigSource[]{source});
                        }
                        return builder;
                    }
                };
            }
        });
    }

    public void performBoottime(OperationContext context, ModelNode operation, ModelNode model) {
        MicroProfileConfigLogger.ROOT_LOGGER.activatingSubsystem();
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("microprofile-config-smallrye", Phase.DEPENDENCIES, 6224, (DeploymentUnitProcessor)new DependencyProcessor());
                processorTarget.addDeploymentProcessor("microprofile-config-smallrye", Phase.POST_MODULE, 14160, (DeploymentUnitProcessor)new SubsystemDeploymentProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

