/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.NamespaceMappingParser;
import org.infinispan.configuration.parsing.Schema;
import org.infinispan.configuration.parsing.URLXMLResourceResolver;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.configuration.parsing.XMLResourceResolver;

final class XMLExtendedStreamReaderImpl
implements XMLExtendedStreamReader {
    private final XMLInputFactory factory;
    final XMLResourceResolver resourceResolver;
    private final NamespaceMappingParser parser;
    private XMLStreamReader streamReader;
    private final Deque<Included> includeStack;
    private final Deque<Context> stack;
    private Schema schema;
    private Properties properties;

    XMLExtendedStreamReaderImpl(XMLInputFactory factory, XMLResourceResolver resourceResolver, NamespaceMappingParser parser, XMLStreamReader streamReader, Properties properties) {
        this(factory, resourceResolver, parser, streamReader, properties, new ArrayDeque<Context>());
        this.stack.push(new Context());
    }

    XMLExtendedStreamReaderImpl(XMLInputFactory factory, XMLResourceResolver resourceResolver, NamespaceMappingParser parser, XMLStreamReader streamReader, Properties properties, Deque<Context> stack) {
        this.factory = factory;
        this.resourceResolver = resourceResolver;
        this.parser = parser;
        this.streamReader = streamReader;
        this.includeStack = new ArrayDeque<Included>();
        this.properties = properties;
        this.stack = stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAny(ConfigurationBuilderHolder holder) throws XMLStreamException {
        this.require(1, null, null);
        boolean ok = false;
        try {
            Deque<Context> stack = this.stack;
            stack.push(new Context());
            try {
                this.parser.parseElement(this, holder);
            }
            finally {
                stack.pop();
            }
            ok = true;
        }
        finally {
            if (!ok) {
                this.safeClose();
            }
        }
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if (this.properties.containsKey(name)) {
            return this.properties.getProperty(name);
        }
        return this.streamReader.getProperty(name);
    }

    @Override
    public int next() throws XMLStreamException {
        Context context = this.stack.getFirst();
        if (context.depth > 0) {
            int next = this.streamReader.next();
            if (next == 2) {
                --context.depth;
                if ("include".equals(this.getLocalName())) {
                    return this.next();
                }
            } else if (next == 1) {
                ++context.depth;
                if ("include".equals(this.getLocalName())) {
                    this.include();
                    return this.next();
                }
            } else if (next == 8 && !this.includeStack.isEmpty()) {
                this.closeInclude();
                return this.next();
            }
            return next;
        }
        try {
            throw XMLExtendedStreamReaderImpl.readPastEnd(this.getLocation());
        }
        catch (Throwable throwable) {
            this.safeClose();
            throw throwable;
        }
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        this.streamReader.require(type, namespaceURI, localName);
    }

    @Override
    public String getElementText() throws XMLStreamException {
        String text = this.streamReader.getElementText().trim();
        return StringPropertyReplacer.replaceProperties((String)text, (Properties)this.properties);
    }

    @Override
    public int nextTag() throws XMLStreamException {
        Context context = this.stack.getFirst();
        if (context.depth > 0) {
            int next = this.nextTag(this.streamReader);
            if (next == 2) {
                --context.depth;
                if ("include".equals(this.getLocalName())) {
                    return this.nextTag();
                }
            } else if (next == 1) {
                ++context.depth;
                if ("include".equals(this.getLocalName())) {
                    this.include();
                    return this.nextTag();
                }
            } else if (next == 8 && !this.includeStack.isEmpty()) {
                this.closeInclude();
                return this.nextTag();
            }
            return next;
        }
        try {
            throw XMLExtendedStreamReaderImpl.readPastEnd(this.getLocation());
        }
        catch (Throwable throwable) {
            this.safeClose();
            throw throwable;
        }
    }

    private int nextTag(XMLStreamReader reader) throws XMLStreamException {
        if (this.includeStack.isEmpty()) {
            return this.streamReader.nextTag();
        }
        int eventType = reader.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2 && eventType != 8) {
            throw new XMLStreamException("found: " + eventType + ", expected 1, 2 or 8", this.getLocation());
        }
        return eventType;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        if (this.stack.getFirst().depth > 0) {
            if (this.streamReader.hasNext()) {
                return true;
            }
            if (!this.includeStack.isEmpty()) {
                this.closeInclude();
                return this.hasNext();
            }
            return false;
        }
        return false;
    }

    @Override
    public void close() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.streamReader.getNamespaceURI(prefix);
    }

    @Override
    public boolean isStartElement() {
        return this.streamReader.isStartElement();
    }

    @Override
    public boolean isEndElement() {
        return this.streamReader.isEndElement();
    }

    @Override
    public boolean isCharacters() {
        return this.streamReader.isCharacters();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.streamReader.isWhiteSpace();
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        String value = this.streamReader.getAttributeValue(namespaceURI, localName);
        return StringPropertyReplacer.replaceProperties((String)value, (Properties)this.properties);
    }

    @Override
    public int getAttributeCount() {
        return this.streamReader.getAttributeCount();
    }

    @Override
    public QName getAttributeName(int index) {
        return this.streamReader.getAttributeName(index);
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.streamReader.getAttributeNamespace(index);
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.streamReader.getAttributeLocalName(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.streamReader.getAttributePrefix(index);
    }

    @Override
    public String getAttributeType(int index) {
        return this.streamReader.getAttributeType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        String value = this.streamReader.getAttributeValue(index);
        return StringPropertyReplacer.replaceProperties((String)value, (Properties)this.properties);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return this.streamReader.isAttributeSpecified(index);
    }

    @Override
    public int getNamespaceCount() {
        return this.streamReader.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int index) {
        return this.streamReader.getNamespacePrefix(index);
    }

    @Override
    public String getNamespaceURI(int index) {
        return this.streamReader.getNamespaceURI(index);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.streamReader.getNamespaceContext();
    }

    @Override
    public int getEventType() {
        return this.streamReader.getEventType();
    }

    @Override
    public String getText() {
        return this.streamReader.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.streamReader.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        return this.streamReader.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextStart() {
        return this.streamReader.getTextStart();
    }

    @Override
    public int getTextLength() {
        return this.streamReader.getTextLength();
    }

    @Override
    public String getEncoding() {
        return this.streamReader.getEncoding();
    }

    @Override
    public boolean hasText() {
        return this.streamReader.hasText();
    }

    @Override
    public Location getLocation() {
        return this.streamReader.getLocation();
    }

    @Override
    public QName getName() {
        return this.streamReader.getName();
    }

    @Override
    public String getLocalName() {
        return this.streamReader.getLocalName();
    }

    @Override
    public boolean hasName() {
        return this.streamReader.hasName();
    }

    @Override
    public String getNamespaceURI() {
        return this.streamReader.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.streamReader.getPrefix();
    }

    @Override
    public String getVersion() {
        return this.streamReader.getVersion();
    }

    @Override
    public boolean isStandalone() {
        return this.streamReader.isStandalone();
    }

    @Override
    public boolean standaloneSet() {
        return this.streamReader.standaloneSet();
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.streamReader.getCharacterEncodingScheme();
    }

    @Override
    public String getPITarget() {
        return this.streamReader.getPITarget();
    }

    @Override
    public String getPIData() {
        return this.streamReader.getPIData();
    }

    @Override
    public String[] getListAttributeValue(int i) {
        return this.getAttributeValue(i).split("\\s+");
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public XMLResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    private void safeClose() {
        try {
            this.streamReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void include() throws XMLStreamException {
        String href = this.getAttributeValue(null, "href");
        try {
            URL url = this.resourceResolver.resolveResource(href);
            InputStream inputStream = url.openStream();
            XMLStreamReader subReader = this.factory.createXMLStreamReader(inputStream);
            this.includeStack.push(new Included(inputStream, this.streamReader));
            this.streamReader = new XMLExtendedStreamReaderImpl(this.factory, new URLXMLResourceResolver(url), this.parser, subReader, this.properties, this.stack);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    private void closeInclude() {
        Included removed = this.includeStack.pop();
        Util.close((AutoCloseable)removed.inputStream);
        this.streamReader = removed.reader;
    }

    private static XMLStreamException readPastEnd(Location location) {
        return new XMLStreamException("Attempt to read past end of element", location);
    }

    private static final class Included {
        InputStream inputStream;
        XMLStreamReader reader;

        Included(InputStream inputStream, XMLStreamReader reader) {
            this.inputStream = inputStream;
            this.reader = reader;
        }
    }

    private static final class Context {
        int depth = 1;

        private Context() {
        }
    }
}

