/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.metadata.impl.PrivateMetadata;

public class TransientMortalCacheValue
extends MortalCacheValue {
    protected long maxIdle;
    protected long lastUsed;

    public TransientMortalCacheValue(Object value, long created, long lifespan, long maxIdle, long lastUsed) {
        this(value, null, created, lifespan, maxIdle, lastUsed);
    }

    protected TransientMortalCacheValue(Object value, PrivateMetadata internalMetadata, long created, long lifespan, long maxIdle, long lastUsed) {
        super(value, internalMetadata, created, lifespan);
        this.maxIdle = maxIdle;
        this.lastUsed = lastUsed;
    }

    @Override
    public long getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransientMortal(this.maxIdle, this.lastUsed, this.lifespan, this.created, now);
    }

    @Override
    public boolean isMaxIdleExpirable() {
        return true;
    }

    @Override
    public InternalCacheEntry<?, ?> toInternalCacheEntry(Object key) {
        return new TransientMortalCacheEntry(key, this.value, this.internalMetadata, this.maxIdle, this.lifespan, this.lastUsed, this.created);
    }

    @Override
    public long getExpiryTime() {
        long muet;
        long lset = this.lifespan > -1L ? this.created + this.lifespan : -1L;
        long l = muet = this.maxIdle > -1L ? this.lastUsed + this.maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransientMortalCacheValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransientMortalCacheValue that = (TransientMortalCacheValue)o;
        return this.lastUsed == that.lastUsed && this.maxIdle == that.maxIdle;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.maxIdle ^ this.maxIdle >>> 32);
        result = 31 * result + (int)(this.lastUsed ^ this.lastUsed >>> 32);
        return result;
    }

    @Override
    public TransientMortalCacheValue clone() {
        return (TransientMortalCacheValue)super.clone();
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", maxIdle=").append(this.maxIdle);
        builder.append(", lastUsed=").append(this.lastUsed);
    }

    public static class Externalizer
    extends AbstractExternalizer<TransientMortalCacheValue> {
        public void writeObject(ObjectOutput output, TransientMortalCacheValue value) throws IOException {
            output.writeObject(value.value);
            output.writeObject(value.internalMetadata);
            UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)value.created);
            output.writeLong(value.lifespan);
            UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)value.lastUsed);
            output.writeLong(value.maxIdle);
        }

        public TransientMortalCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object value = input.readObject();
            PrivateMetadata internalMetadata = (PrivateMetadata)input.readObject();
            long created = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
            long lifespan = input.readLong();
            long lastUsed = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
            long maxIdle = input.readLong();
            return new TransientMortalCacheValue(value, internalMetadata, created, lifespan, maxIdle, lastUsed);
        }

        public Integer getId() {
            return 14;
        }

        public Set<Class<? extends TransientMortalCacheValue>> getTypeClasses() {
            return Collections.singleton(TransientMortalCacheValue.class);
        }
    }
}

