/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.cache.session.CompositeImmutableSession;
import org.wildfly.clustering.web.cache.session.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionMetaData;

public class CompositeSession<L>
extends CompositeImmutableSession
implements Session<L> {
    private final InvalidatableSessionMetaData metaData;
    private final SessionAttributes attributes;
    private final AtomicReference<L> localContext;
    private final LocalContextFactory<L> localContextFactory;
    private final Remover<String> remover;

    public CompositeSession(String id, InvalidatableSessionMetaData metaData, SessionAttributes attributes, AtomicReference<L> localContext, LocalContextFactory<L> localContextFactory, Remover<String> remover) {
        super(id, (ImmutableSessionMetaData)metaData, (ImmutableSessionAttributes)attributes);
        this.metaData = metaData;
        this.attributes = attributes;
        this.localContext = localContext;
        this.localContextFactory = localContextFactory;
        this.remover = remover;
    }

    public SessionAttributes getAttributes() {
        return this.attributes;
    }

    public void invalidate() {
        if (this.metaData.invalidate()) {
            this.remover.remove((Object)this.getId());
        }
    }

    public boolean isValid() {
        return this.metaData.isValid();
    }

    public SessionMetaData getMetaData() {
        return this.metaData;
    }

    public void close() {
        if (this.metaData.isValid()) {
            this.attributes.close();
            this.metaData.setLastAccessedTime(Instant.now());
        }
    }

    public L getLocalContext() {
        if (this.localContextFactory == null) {
            return null;
        }
        Object localContext = this.localContext.get();
        if (localContext == null && !this.localContext.compareAndSet(null, localContext = this.localContextFactory.createLocalContext())) {
            return this.localContext.get();
        }
        return localContext;
    }
}

