/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.netty.buffer;

import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import org.xnio.ByteBufferSlicePool;
import org.xnio.Pooled;
import org.xnio.netty.buffer.PooledByteBuf;

final class XnioByteBufUtil {
    private XnioByteBufUtil() {
    }

    static Pooled<ByteBuffer> allocateDirect(ByteBufferSlicePool pool, int initialCapacity) {
        Object pooled = initialCapacity <= pool.getBufferSize() ? pool.allocate() : new PooledByteBuf(ByteBuffer.allocateDirect(initialCapacity));
        return pooled;
    }

    static void freeDirect(ByteBuffer buffer, ByteBuffer newBuffer) {
        if (buffer != newBuffer) {
            PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
        }
    }
}

