/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.netty.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xnio.ChannelListener;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.netty.transport.AbstractXnioSocketChannel;

public class XnioChannelCloseFuture
implements ChannelFuture,
ChannelListener<ConduitStreamSourceChannel> {
    private IOException error;
    private final AtomicBoolean closed;
    private final AbstractXnioSocketChannel channel;
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private List<GenericFutureListener<? extends Future<? super Void>>> listeners;

    public XnioChannelCloseFuture(AbstractXnioSocketChannel channel) {
        this.closed = new AtomicBoolean(false);
        this.channel = channel;
    }

    public void setError(IOException error) {
        this.error = error;
    }

    public boolean isSuccess() {
        return this.closed.get() && this.error != null;
    }

    public boolean isCancellable() {
        return false;
    }

    public Throwable cause() {
        return this.error;
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        this.countDownLatch.await(timeout, unit);
        return this.closed.get();
    }

    public boolean await(long timeoutMillis) throws InterruptedException {
        this.countDownLatch.await(timeoutMillis, TimeUnit.MILLISECONDS);
        return this.closed.get();
    }

    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        try {
            this.countDownLatch.await(timeout, unit);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.closed.get();
    }

    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            this.countDownLatch.await(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.closed.get();
    }

    public Void getNow() {
        return null;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return this.closed.get();
    }

    public Void get() throws InterruptedException, ExecutionException {
        return null;
    }

    public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.countDownLatch.await(timeout, unit);
        return null;
    }

    public Channel channel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        boolean notify;
        XnioChannelCloseFuture xnioChannelCloseFuture = this;
        synchronized (xnioChannelCloseFuture) {
            if (this.closed.get()) {
                notify = true;
            } else {
                notify = false;
                if (this.listeners == null) {
                    this.listeners = new ArrayList<GenericFutureListener<? extends Future<? super Void>>>();
                }
                this.listeners.add(listener);
            }
        }
        if (notify) {
            this.notifyListener(listener);
        }
        return this;
    }

    private <T extends Future<? super Void>> void notifyListener(GenericFutureListener<T> listener) {
        try {
            listener.operationComplete((Future)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ChannelFuture addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        for (GenericFutureListener<? extends Future<? super Void>> listener : listeners) {
            this.addListener(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        XnioChannelCloseFuture xnioChannelCloseFuture = this;
        synchronized (xnioChannelCloseFuture) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        XnioChannelCloseFuture xnioChannelCloseFuture = this;
        synchronized (xnioChannelCloseFuture) {
            if (this.listeners != null) {
                for (GenericFutureListener<? extends Future<? super Void>> listener : listeners) {
                    this.listeners.remove(listener);
                }
            }
        }
        return this;
    }

    public ChannelFuture sync() throws InterruptedException {
        this.closed.wait();
        if (this.error != null) {
            throw new RuntimeException(this.error);
        }
        return this;
    }

    public ChannelFuture syncUninterruptibly() {
        try {
            this.closed.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.error != null) {
            throw new RuntimeException(this.error);
        }
        return this;
    }

    public ChannelFuture await() throws InterruptedException {
        this.countDownLatch.await();
        return this;
    }

    public ChannelFuture awaitUninterruptibly() {
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this;
    }

    public boolean isVoid() {
        return true;
    }

    public void handleEvent(ConduitStreamSourceChannel channel) {
        this.closed.compareAndSet(false, true);
        this.countDownLatch.countDown();
    }
}

