/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex.dh;

import java.util.Objects;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractDHKeyExchange
extends AbstractLoggingBean
implements KeyExchange {
    protected byte[] v_s;
    protected byte[] v_c;
    protected byte[] i_s;
    protected byte[] i_c;
    protected Digest hash;
    protected byte[] e;
    protected byte[] f;
    protected byte[] k;
    protected byte[] h;
    private final Session session;

    protected AbstractDHKeyExchange(Session session) {
        this.session = Objects.requireNonNull(session, "No session provided");
    }

    @Override
    public void init(byte[] v_s, byte[] v_c, byte[] i_s, byte[] i_c) throws Exception {
        this.v_s = ValidateUtils.checkNotNullAndNotEmpty((byte[])v_s, (String)"No v_s value");
        this.v_c = ValidateUtils.checkNotNullAndNotEmpty((byte[])v_c, (String)"No v_c value");
        this.i_s = ValidateUtils.checkNotNullAndNotEmpty((byte[])i_s, (String)"No i_s value");
        this.i_c = ValidateUtils.checkNotNullAndNotEmpty((byte[])i_c, (String)"No i_c value");
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Digest getHash() {
        return this.hash;
    }

    @Override
    public byte[] getH() {
        return this.h;
    }

    @Override
    public byte[] getK() {
        return this.k;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

