/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.marshalling.spi.util.CollectionExternalizer;

public class CopyOnWriteCollectionExternalizer<T extends Collection<Object>>
implements Externalizer<T> {
    private final Class<T> targetClass;
    private final Function<Collection<Object>, T> factory;

    public CopyOnWriteCollectionExternalizer(Class<?> targetClass, Function<Collection<Object>, T> factory) {
        this.targetClass = targetClass;
        this.factory = factory;
    }

    public void writeObject(ObjectOutput output, T collection) throws IOException {
        CollectionExternalizer.writeCollection(output, collection);
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int size = IndexSerializer.VARIABLE.readInt(input);
        return (T)((Collection)this.factory.apply(CollectionExternalizer.readCollection(input, new ArrayList(size), size)));
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }
}

