/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util.concurrent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.OptionalInt;
import java.util.function.Function;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.BoundedCollectionMarshaller;

public class CopyOnWriteCollectionMarshaller<T extends Collection<Object>>
implements ProtoStreamMarshaller<T> {
    private static final ProtoStreamMarshaller<Collection<Object>> COLLECTION_MARSHALLER = new BoundedCollectionMarshaller<Collection>(Collection.class, ArrayList::new);
    private final Class<T> targetClass;
    private final Function<Collection<Object>, T> factory;

    public CopyOnWriteCollectionMarshaller(Class<T> targetClass, Function<Collection<Object>, T> factory) {
        this.targetClass = targetClass;
        this.factory = factory;
    }

    public T readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        Collection collection = (Collection)COLLECTION_MARSHALLER.readFrom(context, reader);
        return (T)((Collection)this.factory.apply(collection));
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, T collection) throws IOException {
        COLLECTION_MARSHALLER.writeTo(context, writer, collection);
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, T collection) {
        return COLLECTION_MARSHALLER.size(context, collection);
    }

    public Class<? extends T> getJavaClass() {
        return this.targetClass;
    }
}

