/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.SimpleServiceNameProvider;

public class ModuleServiceConfigurator
extends SimpleServiceNameProvider
implements ResourceServiceConfigurator,
Supplier<Module> {
    private final Attribute attribute;
    private volatile String identifier;
    private volatile Supplier<ModuleLoader> loader;

    public ModuleServiceConfigurator(ServiceName name, Attribute attribute) {
        super(name);
        this.attribute = attribute;
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.identifier = this.attribute.resolveModelAttribute((ExpressionResolver)context, model).asString();
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer module = builder.provides(new ServiceName[]{this.getServiceName()});
        this.loader = builder.requires(Services.JBOSS_SERVICE_MODULE_LOADER);
        FunctionalService service = new FunctionalService(module, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service);
    }

    @Override
    public Module get() {
        try {
            return this.loader.get().loadModule(this.identifier);
        }
        catch (ModuleLoadException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

