/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersister;
import org.apache.activemq.artemis.utils.collections.TypedProperties;

public class AMQPMessagePersisterV2
extends AMQPMessagePersister {
    public static final byte ID = 3;
    public static AMQPMessagePersisterV2 theInstance;

    public static AMQPMessagePersisterV2 getInstance() {
        if (theInstance == null) {
            theInstance = new AMQPMessagePersisterV2();
        }
        return theInstance;
    }

    @Override
    public byte getID() {
        return 3;
    }

    @Override
    public int getEncodeSize(Message record) {
        int encodeSize = super.getEncodeSize(record) + 4;
        TypedProperties properties = ((AMQPMessage)record).getExtraProperties();
        return encodeSize + (properties != null ? properties.getEncodeSize() : 0);
    }

    @Override
    public void encode(ActiveMQBuffer buffer, Message record) {
        super.encode(buffer, record);
        TypedProperties properties = ((AMQPMessage)record).getExtraProperties();
        if (properties == null) {
            buffer.writeInt(0);
        } else {
            buffer.writeInt(properties.getEncodeSize());
            properties.encode(buffer.byteBuf());
        }
    }

    @Override
    public Message decode(ActiveMQBuffer buffer, Message record) {
        AMQPMessage message = (AMQPMessage)super.decode(buffer, record);
        int size = buffer.readInt();
        if (size != 0) {
            TypedProperties properties = new TypedProperties();
            properties.decode(buffer.byteBuf());
            message.setExtraProperties(properties);
        }
        return message;
    }
}

