/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.jboss.as.pojo.descriptor.ConfigVisitor;
import org.jboss.as.pojo.descriptor.ConfigVisitorNode;
import org.jboss.as.pojo.descriptor.TypeProvider;
import org.jboss.as.pojo.service.BeanInfo;
import org.jboss.as.pojo.service.DefaultBeanInfo;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;

public abstract class AbstractConfigVisitorNode
implements ConfigVisitorNode,
TypeProvider {
    @Override
    public void visit(ConfigVisitor visitor) {
        visitor.visit(this);
    }

    protected void addChildren(ConfigVisitor visitor, List<ConfigVisitorNode> nodes) {
    }

    @Override
    public Iterable<ConfigVisitorNode> getChildren(ConfigVisitor visitor) {
        ArrayList<ConfigVisitorNode> nodes = new ArrayList<ConfigVisitorNode>();
        this.addChildren(visitor, nodes);
        return nodes;
    }

    protected static BeanInfo getTempBeanInfo(ConfigVisitor visitor, String className) {
        return AbstractConfigVisitorNode.getTempBeanInfo(visitor, AbstractConfigVisitorNode.getType(visitor, className));
    }

    protected static BeanInfo getTempBeanInfo(ConfigVisitor visitor, Class<?> clazz) {
        return new DefaultBeanInfo(visitor.getReflectionIndex(), clazz);
    }

    protected static BeanInfo getTempBeanInfo(Class<?> clazz) {
        return new DefaultBeanInfo(DeploymentReflectionIndex.create(), clazz);
    }

    protected static Class<?> getType(ConfigVisitor visitor, String className) {
        if (className != null) {
            try {
                return visitor.getModule().getClassLoader().loadClass(className);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    static Type getComponentType(ParameterizedType type, int index) {
        Type[] tp = type.getActualTypeArguments();
        if (index + 1 > tp.length) {
            return null;
        }
        return tp[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getType(ConfigVisitor visitor, ConfigVisitorNode previous) {
        Deque<ConfigVisitorNode> nodes = visitor.getCurrentNodes();
        if (nodes.isEmpty()) {
            throw new IllegalArgumentException("Cannot determine type - insufficient info on configuration!");
        }
        ConfigVisitorNode current = nodes.pop();
        try {
            if (current instanceof TypeProvider) {
                Class<?> clazz = ((TypeProvider)TypeProvider.class.cast(current)).getType(visitor, current);
                return clazz;
            }
            Class<?> clazz = this.getType(visitor, current);
            return clazz;
        }
        finally {
            nodes.push(current);
        }
    }
}

