/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics;

import io.smallrye.metrics.MetricRegistries;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.microprofile.metrics.MetricCollector;
import org.wildfly.extension.microprofile.metrics.MicroProfileMetricsSubsystemDefinition;

public class MetricsCollectorService
implements Service<MetricCollector> {
    private final Supplier<ModelControllerClientFactory> modelControllerClientFactory;
    private final Supplier<Executor> managementExecutor;
    private final Supplier<ProcessStateNotifier> processStateNotifier;
    private final List<String> exposedSubsystems;
    private final String globalPrefix;
    private MetricCollector metricCollector;
    private LocalModelControllerClient modelControllerClient;

    static void install(OperationContext context, List<String> exposedSubsystems, String prefix) {
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(MicroProfileMetricsSubsystemDefinition.WILDFLY_COLLECTOR_SERVICE);
        Supplier modelControllerClientFactory = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.model-controller-client-factory", ModelControllerClientFactory.class));
        Supplier managementExecutor = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.executor", Executor.class));
        Supplier processStateNotifier = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.process-state-notifier", ProcessStateNotifier.class));
        MetricsCollectorService service = new MetricsCollectorService(modelControllerClientFactory, managementExecutor, processStateNotifier, exposedSubsystems, prefix);
        serviceBuilder.setInstance((org.jboss.msc.Service)service).install();
    }

    MetricsCollectorService(Supplier<ModelControllerClientFactory> modelControllerClientFactory, Supplier<Executor> managementExecutor, Supplier<ProcessStateNotifier> processStateNotifier, List<String> exposedSubsystems, String globalPrefix) {
        this.modelControllerClientFactory = modelControllerClientFactory;
        this.managementExecutor = managementExecutor;
        this.processStateNotifier = processStateNotifier;
        this.exposedSubsystems = exposedSubsystems;
        this.globalPrefix = globalPrefix;
    }

    public void start(StartContext context) {
        this.modelControllerClient = this.modelControllerClientFactory.get().createClient(this.managementExecutor.get());
        this.metricCollector = new MetricCollector(this.modelControllerClient, this.processStateNotifier.get(), this.exposedSubsystems, this.globalPrefix);
    }

    public void stop(StopContext context) {
        for (MetricRegistry registry : new MetricRegistry[]{MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.BASE), MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR)}) {
            for (String name : registry.getNames()) {
                registry.remove(name);
            }
        }
        this.modelControllerClient.close();
    }

    public MetricCollector getValue() throws IllegalStateException, IllegalArgumentException {
        return this.metricCollector;
    }
}

