/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.util.EnumSet;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.AuthorizationHelper;
import org.infinispan.util.concurrent.CompletableFutures;

public class DefaultCacheManagerAdmin
implements EmbeddedCacheManagerAdmin {
    private final EmbeddedCacheManager cacheManager;
    private final GlobalConfigurationManager clusterConfigurationManager;
    private final AuthorizationHelper authzHelper;
    private final EnumSet<CacheContainerAdmin.AdminFlag> flags;
    private final Subject subject;

    DefaultCacheManagerAdmin(EmbeddedCacheManager cm, AuthorizationHelper authzHelper, EnumSet<CacheContainerAdmin.AdminFlag> flags, Subject subject, GlobalConfigurationManager clusterConfigurationManager) {
        this.cacheManager = cm;
        this.authzHelper = authzHelper;
        this.clusterConfigurationManager = clusterConfigurationManager;
        this.flags = flags;
        this.subject = subject;
    }

    @Override
    public <K, V> Cache<K, V> createCache(String cacheName, Configuration configuration) {
        this.authzHelper.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        CompletableFutures.uncheckedAwait(this.clusterConfigurationManager.createCache(cacheName, configuration, this.flags));
        return this.cacheManager.getCache(cacheName);
    }

    @Override
    public <K, V> Cache<K, V> getOrCreateCache(String cacheName, Configuration configuration) {
        this.authzHelper.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        CompletableFutures.uncheckedAwait(this.clusterConfigurationManager.getOrCreateCache(cacheName, configuration, this.flags));
        return this.cacheManager.getCache(cacheName);
    }

    @Override
    public <K, V> Cache<K, V> createCache(String cacheName, String template) {
        this.authzHelper.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        CompletableFutures.uncheckedAwait(this.clusterConfigurationManager.createCache(cacheName, template, this.flags));
        return this.cacheManager.getCache(cacheName);
    }

    @Override
    public <K, V> Cache<K, V> getOrCreateCache(String cacheName, String template) {
        this.authzHelper.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        CompletableFutures.uncheckedAwait(this.clusterConfigurationManager.getOrCreateCache(cacheName, template, this.flags));
        return this.cacheManager.getCache(cacheName);
    }

    public void removeCache(String cacheName) {
        this.authzHelper.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        CompletableFutures.uncheckedAwait(this.clusterConfigurationManager.removeCache(cacheName, this.flags));
    }

    public EmbeddedCacheManagerAdmin withFlags(CacheContainerAdmin.AdminFlag ... flags) {
        EnumSet<CacheContainerAdmin.AdminFlag> newFlags = EnumSet.copyOf(this.flags);
        for (CacheContainerAdmin.AdminFlag flag : flags) {
            newFlags.add(flag);
        }
        return new DefaultCacheManagerAdmin(this.cacheManager, this.authzHelper, newFlags, this.subject, this.clusterConfigurationManager);
    }

    public EmbeddedCacheManagerAdmin withFlags(EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        EnumSet<CacheContainerAdmin.AdminFlag> newFlags = EnumSet.copyOf(this.flags);
        newFlags.addAll(flags);
        return new DefaultCacheManagerAdmin(this.cacheManager, this.authzHelper, newFlags, this.subject, this.clusterConfigurationManager);
    }

    @Override
    public EmbeddedCacheManagerAdmin withSubject(Subject subject) {
        return new DefaultCacheManagerAdmin(this.cacheManager, this.authzHelper, this.flags, subject, this.clusterConfigurationManager);
    }
}

