/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl.marshallers;

import java.io.IOException;
import java.util.UUID;
import org.infinispan.protostream.MessageMarshaller;

public class UUIDMarshaller
implements MessageMarshaller<UUID> {
    private final String typeName;

    public UUIDMarshaller(String typeName) {
        this.typeName = typeName;
    }

    public UUID readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        long mostSigBits = reader.readLong("mostSigBits");
        long leastSigBits = reader.readLong("leastSigBits");
        return new UUID(mostSigBits, leastSigBits);
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, UUID uuid) throws IOException {
        writer.writeLong("mostSigBits", uuid.getMostSignificantBits());
        writer.writeLong("leastSigBits", uuid.getLeastSignificantBits());
    }

    public Class<? extends UUID> getJavaClass() {
        return UUID.class;
    }

    public String getTypeName() {
        return this.typeName;
    }
}

