/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.rxjava2;

import io.reactivex.Flowable;
import io.reactivex.functions.BiFunction;
import java.util.Map;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ResteasyContextPropagatingOnFlowableCreateAction
implements BiFunction<Flowable, Subscriber, Subscriber> {
    public Subscriber apply(Flowable t1, Subscriber t2) throws Exception {
        return new ContextCapturerSubscriber(t2);
    }

    static final class ContextCapturerSubscriber<T>
    implements Subscriber<T> {
        final Map<Class<?>, Object> contextDataMap = ResteasyProviderFactory.getContextDataMap();
        final Subscriber<T> actual;

        ContextCapturerSubscriber(Subscriber<T> actual) {
            this.actual = actual;
        }

        public void onError(Throwable e) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            this.actual.onError(e);
            ResteasyProviderFactory.removeContextDataLevel();
        }

        public void onNext(T t) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            this.actual.onNext(t);
            ResteasyProviderFactory.removeContextDataLevel();
        }

        public void onComplete() {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            this.actual.onComplete();
            ResteasyProviderFactory.removeContextDataLevel();
        }

        public void onSubscribe(Subscription d) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            this.actual.onSubscribe(d);
            ResteasyProviderFactory.removeContextDataLevel();
        }
    }
}

