/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.hibernate.impl.EntityInfoLoadKey;
import org.hibernate.search.query.hibernate.impl.ObjectInitializationContext;
import org.hibernate.search.query.hibernate.impl.ObjectInitializer;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class PersistenceContextObjectInitializer
implements ObjectInitializer {
    private static final Log log = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    private final ObjectInitializer delegate;

    public PersistenceContextObjectInitializer(ObjectInitializer delegate) {
        this.delegate = delegate;
    }

    @Override
    public void initializeObjects(List<EntityInfo> entityInfos, LinkedHashMap<EntityInfoLoadKey, Object> idToObjectMap, ObjectInitializationContext objectInitializationContext) {
        int numberOfObjectsToInitialize = entityInfos.size();
        if (numberOfObjectsToInitialize == 0) {
            log.tracef("No object to initialize", new Object[0]);
            return;
        }
        SessionImplementor sessionImplementor = objectInitializationContext.getSession();
        MetamodelImplementor metamodelImplementor = sessionImplementor.getSessionFactory().getMetamodel();
        EntityPersister persister = metamodelImplementor.entityPersister(objectInitializationContext.getEntityType());
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        ArrayList<EntityInfo> remainingEntityInfos = new ArrayList<EntityInfo>(numberOfObjectsToInitialize);
        for (EntityInfo entityInfo : entityInfos) {
            if (ObjectLoaderHelper.areDocIdAndEntityIdIdentical(entityInfo, objectInitializationContext.getSession())) {
                EntityKey entityKey = sessionImplementor.generateEntityKey(entityInfo.getId(), persister);
                Object o = persistenceContext.getEntity(entityKey);
                if (o == null) {
                    remainingEntityInfos.add(entityInfo);
                    continue;
                }
                EntityInfoLoadKey key = new EntityInfoLoadKey(entityInfo.getType().getPojoType(), entityInfo.getId());
                idToObjectMap.put(key, o);
                continue;
            }
            remainingEntityInfos.add(entityInfo);
        }
        int remainingSize = remainingEntityInfos.size();
        if (log.isTraceEnabled()) {
            log.tracef("Initialized %d objects out of %d in the persistence context", (Object)(numberOfObjectsToInitialize - remainingSize), (Object)numberOfObjectsToInitialize);
        }
        if (remainingSize > 0) {
            this.delegate.initializeObjects(remainingEntityInfos, idToObjectMap, objectInitializationContext);
        }
    }
}

