/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.configuration;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import org.jboss.ws.api.annotation.EndpointConfig;
import org.jboss.ws.common.Messages;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.config.ConfigMetaDataParser;
import org.jboss.wsf.spi.metadata.config.ConfigRoot;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public abstract class AbstractCommonConfigResolver {
    public org.jboss.wsf.spi.metadata.config.EndpointConfig resolveEndpointConfig() {
        block18: {
            String epCfgFileOverride;
            String epCfgNameOverride;
            String endpointClassName;
            String configName = endpointClassName = this.getEndpointClassName();
            String configFile = "jaxws-endpoint-config.xml";
            boolean specifiedConfig = false;
            if (this.isEndpointClassAnnotated(EndpointConfig.class)) {
                String cfgFile;
                String cfgName = this.getEndpointConfigNameFromAnnotation();
                if (cfgName != null && !cfgName.isEmpty()) {
                    configName = cfgName;
                }
                if ((cfgFile = this.getEndpointConfigFileFromAnnotation()) != null && !cfgFile.isEmpty()) {
                    configFile = cfgFile;
                }
                specifiedConfig = true;
            }
            if ((epCfgNameOverride = this.getEndpointConfigNameOverride()) != null && !epCfgNameOverride.isEmpty()) {
                configName = epCfgNameOverride;
                specifiedConfig = true;
            }
            if ((epCfgFileOverride = this.getEndpointConfigFileOverride()) != null && !epCfgFileOverride.isEmpty()) {
                configFile = epCfgFileOverride;
            }
            if (configFile != "jaxws-endpoint-config.xml") {
                try {
                    ConfigRoot configRoot = ConfigMetaDataParser.parse((URL)this.getConfigFile(configFile));
                    org.jboss.wsf.spi.metadata.config.EndpointConfig config = configRoot.getEndpointConfigByName(configName);
                    if (config == null && !specifiedConfig) {
                        config = configRoot.getEndpointConfigByName("Standard-Endpoint-Config");
                    }
                    if (config != null) {
                        return config;
                    }
                    break block18;
                }
                catch (IOException e) {
                    throw Messages.MESSAGES.couldNotReadConfigFile(configFile);
                }
            }
            org.jboss.wsf.spi.metadata.config.EndpointConfig config = null;
            URL url = this.getDefaultConfigFile(configFile);
            if (url != null) {
                try {
                    ConfigRoot configRoot = ConfigMetaDataParser.parse((URL)url);
                    config = configRoot.getEndpointConfigByName(configName);
                    if (config == null && !specifiedConfig) {
                        config = configRoot.getEndpointConfigByName("Standard-Endpoint-Config");
                    }
                }
                catch (IOException e) {
                    throw Messages.MESSAGES.couldNotReadConfigFile(configFile);
                }
            }
            if (config == null) {
                ServerConfig sc = this.getServerConfig();
                config = sc.getEndpointConfig(configName);
                if (config == null && !specifiedConfig) {
                    config = sc.getEndpointConfig("Standard-Endpoint-Config");
                }
                if (config == null && specifiedConfig) {
                    throw Messages.MESSAGES.couldNotFindEndpointConfigName(configName);
                }
            }
            if (config != null) {
                return config;
            }
        }
        return null;
    }

    public Set<String> getAllHandlers(org.jboss.wsf.spi.metadata.config.EndpointConfig config) {
        HashSet<String> set = new HashSet<String>();
        if (config != null) {
            for (UnifiedHandlerChainMetaData uhcmd : config.getPreHandlerChains()) {
                for (UnifiedHandlerMetaData uhmd : uhcmd.getHandlers()) {
                    set.add(uhmd.getHandlerClass());
                }
            }
            for (UnifiedHandlerChainMetaData uhcmd : config.getPostHandlerChains()) {
                for (UnifiedHandlerMetaData uhmd : uhcmd.getHandlers()) {
                    set.add(uhmd.getHandlerClass());
                }
            }
        }
        return set;
    }

    protected abstract String getEndpointClassName();

    protected abstract <T extends Annotation> boolean isEndpointClassAnnotated(Class<T> var1);

    protected abstract String getEndpointConfigNameFromAnnotation();

    protected abstract String getEndpointConfigFileFromAnnotation();

    protected abstract String getEndpointConfigNameOverride();

    protected abstract String getEndpointConfigFileOverride();

    protected abstract URL getConfigFile(String var1) throws IOException;

    protected abstract URL getDefaultConfigFile(String var1);

    protected ServerConfig getServerConfig() {
        if (System.getSecurityManager() == null) {
            return AbstractServerConfig.getServerIntegrationServerConfig();
        }
        return AccessController.doPrivileged(AbstractServerConfig.GET_SERVER_INTEGRATION_SERVER_CONFIG);
    }
}

